/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.AssociatedResourceType;
import software.amazon.awssdk.services.wafv2.model.RequestBodyAssociatedResourceTypeConfig;
import software.amazon.awssdk.services.wafv2.model.RequestBodyCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationConfig> {
    private static final SdkField<Map<String, RequestBodyAssociatedResourceTypeConfig>> REQUEST_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestBody").getter(AssociationConfig.getter(AssociationConfig::requestBodyAsStrings)).setter(AssociationConfig.setter(Builder::requestBodyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBody").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestBodyAssociatedResourceTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_BODY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody;

    private AssociationConfig(BuilderImpl builder) {
        this.requestBody = builder.requestBody;
    }

    public final Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> requestBody() {
        return RequestBodyCopier.copyStringToEnum(this.requestBody);
    }

    public final boolean hasRequestBody() {
        return this.requestBody != null && !(this.requestBody instanceof SdkAutoConstructMap);
    }

    public final Map<String, RequestBodyAssociatedResourceTypeConfig> requestBodyAsStrings() {
        return this.requestBody;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestBody() ? this.requestBodyAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationConfig)) {
            return false;
        }
        AssociationConfig other = (AssociationConfig)obj;
        return this.hasRequestBody() == other.hasRequestBody() && Objects.equals(this.requestBodyAsStrings(), other.requestBodyAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationConfig").add("RequestBody", this.hasRequestBody() ? this.requestBodyAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestBody": {
                return Optional.ofNullable(clazz.cast(this.requestBodyAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationConfig, T> g) {
        return obj -> g.apply((AssociationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationConfig model) {
            this.requestBodyWithStrings(model.requestBody);
        }

        public final Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> getRequestBody() {
            Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> result = RequestBodyCopier.copyToBuilder(this.requestBody);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRequestBody(Map<String, RequestBodyAssociatedResourceTypeConfig.BuilderImpl> requestBody) {
            this.requestBody = RequestBodyCopier.copyFromBuilder(requestBody);
        }

        @Override
        public final Builder requestBodyWithStrings(Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody) {
            this.requestBody = RequestBodyCopier.copy(requestBody);
            return this;
        }

        @Override
        public final Builder requestBody(Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> requestBody) {
            this.requestBody = RequestBodyCopier.copyEnumToString(requestBody);
            return this;
        }

        public AssociationConfig build() {
            return new AssociationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationConfig> {
        public Builder requestBodyWithStrings(Map<String, RequestBodyAssociatedResourceTypeConfig> var1);

        public Builder requestBody(Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> var1);
    }
}

