/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wafv2.DefaultWafv2BaseClientBuilder;
import software.amazon.awssdk.services.wafv2.DefaultWafv2Client;
import software.amazon.awssdk.services.wafv2.Wafv2Client;
import software.amazon.awssdk.services.wafv2.Wafv2ClientBuilder;
import software.amazon.awssdk.services.wafv2.Wafv2ServiceClientConfiguration;
import software.amazon.awssdk.services.wafv2.endpoints.Wafv2EndpointProvider;

@SdkInternalApi
final class DefaultWafv2ClientBuilder
extends DefaultWafv2BaseClientBuilder<Wafv2ClientBuilder, Wafv2Client>
implements Wafv2ClientBuilder {
    DefaultWafv2ClientBuilder() {
    }

    @Override
    public DefaultWafv2ClientBuilder endpointProvider(Wafv2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Wafv2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWafv2ClientBuilder.validateClientOptions(clientConfiguration);
        Wafv2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWafv2Client client = new DefaultWafv2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Wafv2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Wafv2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

