/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterRequirement {
    MEETS_ALL("MEETS_ALL"),
    MEETS_ANY("MEETS_ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterRequirement> VALUE_MAP;
    private final String value;

    private FilterRequirement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterRequirement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterRequirement> knownValues() {
        EnumSet<FilterRequirement> knownValues = EnumSet.allOf(FilterRequirement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterRequirement.class, FilterRequirement::toString);
    }
}

