/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.RegexPatternSetSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.RegexPatternSetSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegexPatternSetsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListRegexPatternSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListRegexPatternSetsResponse.getter(ListRegexPatternSetsResponse::nextMarker)).setter(ListRegexPatternSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<RegexPatternSetSummary>> REGEX_PATTERN_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegexPatternSets").getter(ListRegexPatternSetsResponse.getter(ListRegexPatternSetsResponse::regexPatternSets)).setter(ListRegexPatternSetsResponse.setter(Builder::regexPatternSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegexPatternSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, REGEX_PATTERN_SETS_FIELD));
    private final String nextMarker;
    private final List<RegexPatternSetSummary> regexPatternSets;

    private ListRegexPatternSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexPatternSets = builder.regexPatternSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasRegexPatternSets() {
        return this.regexPatternSets != null && !(this.regexPatternSets instanceof SdkAutoConstructList);
    }

    public final List<RegexPatternSetSummary> regexPatternSets() {
        return this.regexPatternSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexPatternSets() ? this.regexPatternSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexPatternSetsResponse)) {
            return false;
        }
        ListRegexPatternSetsResponse other = (ListRegexPatternSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasRegexPatternSets() == other.hasRegexPatternSets() && Objects.equals(this.regexPatternSets(), other.regexPatternSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegexPatternSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("RegexPatternSets", this.hasRegexPatternSets() ? this.regexPatternSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RegexPatternSets": {
                return Optional.ofNullable(clazz.cast(this.regexPatternSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegexPatternSetsResponse, T> g) {
        return obj -> g.apply((ListRegexPatternSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RegexPatternSetSummary> regexPatternSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexPatternSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.regexPatternSets(model.regexPatternSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<RegexPatternSetSummary.Builder> getRegexPatternSets() {
            List<RegexPatternSetSummary.Builder> result = RegexPatternSetSummariesCopier.copyToBuilder(this.regexPatternSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexPatternSets(Collection<RegexPatternSetSummary.BuilderImpl> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copyFromBuilder(regexPatternSets);
        }

        @Override
        public final Builder regexPatternSets(Collection<RegexPatternSetSummary> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copy(regexPatternSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(RegexPatternSetSummary ... regexPatternSets) {
            this.regexPatternSets(Arrays.asList(regexPatternSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder> ... regexPatternSets) {
            this.regexPatternSets(Stream.of(regexPatternSets).map(c -> (RegexPatternSetSummary)((RegexPatternSetSummary.Builder)RegexPatternSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegexPatternSetsResponse build() {
            return new ListRegexPatternSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegexPatternSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder regexPatternSets(Collection<RegexPatternSetSummary> var1);

        public Builder regexPatternSets(RegexPatternSetSummary ... var1);

        public Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder> ... var1);
    }
}

