/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.services.wafv2.model.WebACL;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWebAclResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, GetWebAclResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebACL").getter(GetWebAclResponse.getter(GetWebAclResponse::webACL)).setter(GetWebAclResponse.setter(Builder::webACL)).constructor(WebACL::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()}).build();
    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockToken").getter(GetWebAclResponse.getter(GetWebAclResponse::lockToken)).setter(GetWebAclResponse.setter(Builder::lockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()}).build();
    private static final SdkField<String> APPLICATION_INTEGRATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIntegrationURL").getter(GetWebAclResponse.getter(GetWebAclResponse::applicationIntegrationURL)).setter(GetWebAclResponse.setter(Builder::applicationIntegrationURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIntegrationURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD, LOCK_TOKEN_FIELD, APPLICATION_INTEGRATION_URL_FIELD));
    private final WebACL webACL;
    private final String lockToken;
    private final String applicationIntegrationURL;

    private GetWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
        this.lockToken = builder.lockToken;
        this.applicationIntegrationURL = builder.applicationIntegrationURL;
    }

    public final WebACL webACL() {
        return this.webACL;
    }

    public final String lockToken() {
        return this.lockToken;
    }

    public final String applicationIntegrationURL() {
        return this.applicationIntegrationURL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webACL());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIntegrationURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclResponse)) {
            return false;
        }
        GetWebAclResponse other = (GetWebAclResponse)((Object)obj);
        return Objects.equals(this.webACL(), other.webACL()) && Objects.equals(this.lockToken(), other.lockToken()) && Objects.equals(this.applicationIntegrationURL(), other.applicationIntegrationURL());
    }

    public final String toString() {
        return ToString.builder((String)"GetWebAclResponse").add("WebACL", (Object)this.webACL()).add("LockToken", (Object)this.lockToken()).add("ApplicationIntegrationURL", (Object)this.applicationIntegrationURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACL": {
                return Optional.ofNullable(clazz.cast(this.webACL()));
            }
            case "LockToken": {
                return Optional.ofNullable(clazz.cast(this.lockToken()));
            }
            case "ApplicationIntegrationURL": {
                return Optional.ofNullable(clazz.cast(this.applicationIntegrationURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclResponse, T> g) {
        return obj -> g.apply((GetWebAclResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private WebACL webACL;
        private String lockToken;
        private String applicationIntegrationURL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclResponse model) {
            super(model);
            this.webACL(model.webACL);
            this.lockToken(model.lockToken);
            this.applicationIntegrationURL(model.applicationIntegrationURL);
        }

        public final WebACL.Builder getWebACL() {
            return this.webACL != null ? this.webACL.toBuilder() : null;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        @Override
        @Transient
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final String getLockToken() {
            return this.lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        @Transient
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        public final String getApplicationIntegrationURL() {
            return this.applicationIntegrationURL;
        }

        public final void setApplicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
        }

        @Override
        @Transient
        public final Builder applicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
            return this;
        }

        @Override
        public GetWebAclResponse build() {
            return new GetWebAclResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWebAclResponse> {
        public Builder webACL(WebACL var1);

        default public Builder webACL(Consumer<WebACL.Builder> webACL) {
            return this.webACL((WebACL)((WebACL.Builder)WebACL.builder().applyMutation(webACL)).build());
        }

        public Builder lockToken(String var1);

        public Builder applicationIntegrationURL(String var1);
    }
}

