/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionValue {
    ALLOW("ALLOW"),
    BLOCK("BLOCK"),
    COUNT("COUNT"),
    CAPTCHA("CAPTCHA"),
    EXCLUDED_AS_COUNT("EXCLUDED_AS_COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionValue> VALUE_MAP;
    private final String value;

    private ActionValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionValue> knownValues() {
        EnumSet<ActionValue> knownValues = EnumSet.allOf(ActionValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionValue.class, ActionValue::toString);
    }
}

