/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersion;
import software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupVersionsCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableManagedRuleGroupVersionsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListAvailableManagedRuleGroupVersionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListAvailableManagedRuleGroupVersionsResponse.getter(ListAvailableManagedRuleGroupVersionsResponse::nextMarker)).setter(ListAvailableManagedRuleGroupVersionsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<ManagedRuleGroupVersion>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Versions").getter(ListAvailableManagedRuleGroupVersionsResponse.getter(ListAvailableManagedRuleGroupVersionsResponse::versions)).setter(ListAvailableManagedRuleGroupVersionsResponse.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedRuleGroupVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, VERSIONS_FIELD));
    private final String nextMarker;
    private final List<ManagedRuleGroupVersion> versions;

    private ListAvailableManagedRuleGroupVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.versions = builder.versions;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<ManagedRuleGroupVersion> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableManagedRuleGroupVersionsResponse)) {
            return false;
        }
        ListAvailableManagedRuleGroupVersionsResponse other = (ListAvailableManagedRuleGroupVersionsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableManagedRuleGroupVersionsResponse").add("NextMarker", (Object)this.nextMarker()).add("Versions", this.hasVersions() ? this.versions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableManagedRuleGroupVersionsResponse, T> g) {
        return obj -> g.apply((ListAvailableManagedRuleGroupVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ManagedRuleGroupVersion> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableManagedRuleGroupVersionsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.versions(model.versions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ManagedRuleGroupVersion.Builder> getVersions() {
            List<ManagedRuleGroupVersion.Builder> result = ManagedRuleGroupVersionsCopier.copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersions(Collection<ManagedRuleGroupVersion.BuilderImpl> versions) {
            this.versions = ManagedRuleGroupVersionsCopier.copyFromBuilder(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<ManagedRuleGroupVersion> versions) {
            this.versions = ManagedRuleGroupVersionsCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(ManagedRuleGroupVersion ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(Consumer<ManagedRuleGroupVersion.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (ManagedRuleGroupVersion)((ManagedRuleGroupVersion.Builder)ManagedRuleGroupVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAvailableManagedRuleGroupVersionsResponse build() {
            return new ListAvailableManagedRuleGroupVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableManagedRuleGroupVersionsResponse> {
        public Builder nextMarker(String var1);

        public Builder versions(Collection<ManagedRuleGroupVersion> var1);

        public Builder versions(ManagedRuleGroupVersion ... var1);

        public Builder versions(Consumer<ManagedRuleGroupVersion.Builder> ... var1);
    }
}

