/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Regex;
import software.amazon.awssdk.services.wafv2.model.RegularExpressionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexPatternSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegexPatternSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegexPatternSet.getter(RegexPatternSet::name)).setter(RegexPatternSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RegexPatternSet.getter(RegexPatternSet::id)).setter(RegexPatternSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(RegexPatternSet.getter(RegexPatternSet::arn)).setter(RegexPatternSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RegexPatternSet.getter(RegexPatternSet::description)).setter(RegexPatternSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Regex>> REGULAR_EXPRESSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegularExpressionList").getter(RegexPatternSet.getter(RegexPatternSet::regularExpressionList)).setter(RegexPatternSet.setter(Builder::regularExpressionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegularExpressionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Regex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, REGULAR_EXPRESSION_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String description;
    private final List<Regex> regularExpressionList;

    private RegexPatternSet(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.regularExpressionList = builder.regularExpressionList;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRegularExpressionList() {
        return this.regularExpressionList != null && !(this.regularExpressionList instanceof SdkAutoConstructList);
    }

    public final List<Regex> regularExpressionList() {
        return this.regularExpressionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegularExpressionList() ? this.regularExpressionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSet)) {
            return false;
        }
        RegexPatternSet other = (RegexPatternSet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasRegularExpressionList() == other.hasRegularExpressionList() && Objects.equals(this.regularExpressionList(), other.regularExpressionList());
    }

    public final String toString() {
        return ToString.builder((String)"RegexPatternSet").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Description", (Object)this.description()).add("RegularExpressionList", this.hasRegularExpressionList() ? this.regularExpressionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RegularExpressionList": {
                return Optional.ofNullable(clazz.cast(this.regularExpressionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSet, T> g) {
        return obj -> g.apply((RegexPatternSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String description;
        private List<Regex> regularExpressionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSet model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.description(model.description);
            this.regularExpressionList(model.regularExpressionList);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Regex.Builder> getRegularExpressionList() {
            if (this.regularExpressionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regularExpressionList != null ? (Collection)this.regularExpressionList.stream().map(Regex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regularExpressionList(Collection<Regex> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copy(regularExpressionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Regex ... regularExpressionList) {
            this.regularExpressionList(Arrays.asList(regularExpressionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Consumer<Regex.Builder> ... regularExpressionList) {
            this.regularExpressionList(Stream.of(regularExpressionList).map(c -> (Regex)((Regex.Builder)Regex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegularExpressionList(Collection<Regex.BuilderImpl> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copyFromBuilder(regularExpressionList);
        }

        public RegexPatternSet build() {
            return new RegexPatternSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegexPatternSet> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder regularExpressionList(Collection<Regex> var1);

        public Builder regularExpressionList(Regex ... var1);

        public Builder regularExpressionList(Consumer<Regex.Builder> ... var1);
    }
}

