/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement used to search web request components for matches with regular expressions. To use this, create a
 * <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in this
 * statement. A web request matches the pattern set rule statement if the request component matches any of the patterns
 * in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.
 * </p>
 * <p>
 * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of
 * your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF
 * automatically updates all rules that reference it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexPatternSetReferenceStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexPatternSetReferenceStatement.Builder, RegexPatternSetReferenceStatement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(RegexPatternSetReferenceStatement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.<FieldToMatch> builder(MarshallingType.SDK_POJO)
            .memberName("FieldToMatch").getter(getter(RegexPatternSetReferenceStatement::fieldToMatch))
            .setter(setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()).build();

    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField
            .<List<TextTransformation>> builder(MarshallingType.LIST)
            .memberName("TextTransformations")
            .getter(getter(RegexPatternSetReferenceStatement::textTransformations))
            .setter(setter(Builder::textTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            FIELD_TO_MATCH_FIELD, TEXT_TRANSFORMATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final FieldToMatch fieldToMatch;

    private final List<TextTransformation> textTransformations;

    private RegexPatternSetReferenceStatement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformations = builder.textTransformations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The part of a web request that you want AWS WAF to inspect. For more information, see <a>FieldToMatch</a>.
     * </p>
     * 
     * @return The part of a web request that you want AWS WAF to inspect. For more information, see
     *         <a>FieldToMatch</a>.
     */
    public final FieldToMatch fieldToMatch() {
        return fieldToMatch;
    }

    /**
     * Returns true if the TextTransformations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTextTransformations() {
        return textTransformations != null && !(textTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to
     * bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all
     * transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from
     * the lowest priority setting, before inspecting the content for a match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTextTransformations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
     *         effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF
     *         performs all transformations on the content of the request component identified by
     *         <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a
     *         match.
     */
    public final List<TextTransformation> textTransformations() {
        return textTransformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(hasTextTransformations() ? textTransformations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSetReferenceStatement)) {
            return false;
        }
        RegexPatternSetReferenceStatement other = (RegexPatternSetReferenceStatement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(fieldToMatch(), other.fieldToMatch())
                && hasTextTransformations() == other.hasTextTransformations()
                && Objects.equals(textTransformations(), other.textTransformations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexPatternSetReferenceStatement").add("ARN", arn()).add("FieldToMatch", fieldToMatch())
                .add("TextTransformations", hasTextTransformations() ? textTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FieldToMatch":
            return Optional.ofNullable(clazz.cast(fieldToMatch()));
        case "TextTransformations":
            return Optional.ofNullable(clazz.cast(textTransformations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSetReferenceStatement, T> g) {
        return obj -> g.apply((RegexPatternSetReferenceStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexPatternSetReferenceStatement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The part of a web request that you want AWS WAF to inspect. For more information, see <a>FieldToMatch</a>.
         * </p>
         * 
         * @param fieldToMatch
         *        The part of a web request that you want AWS WAF to inspect. For more information, see
         *        <a>FieldToMatch</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldToMatch(FieldToMatch fieldToMatch);

        /**
         * <p>
         * The part of a web request that you want AWS WAF to inspect. For more information, see <a>FieldToMatch</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link FieldToMatch.Builder} avoiding the need to
         * create one manually via {@link FieldToMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link FieldToMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldToMatch(FieldToMatch)}.
         * 
         * @param fieldToMatch
         *        a consumer that will call methods on {@link FieldToMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldToMatch(FieldToMatch)
         */
        default Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return fieldToMatch(FieldToMatch.builder().applyMutation(fieldToMatch).build());
        }

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all
         * transformations on the content of the request component identified by <code>FieldToMatch</code>, starting
         * from the lowest priority setting, before inspecting the content for a match.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF
         *        performs all transformations on the content of the request component identified by
         *        <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content
         *        for a match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(Collection<TextTransformation> textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all
         * transformations on the content of the request component identified by <code>FieldToMatch</code>, starting
         * from the lowest priority setting, before inspecting the content for a match.
         * </p>
         * 
         * @param textTransformations
         *        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an
         *        effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF
         *        performs all transformations on the content of the request component identified by
         *        <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content
         *        for a match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTransformations(TextTransformation... textTransformations);

        /**
         * <p>
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort
         * to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all
         * transformations on the content of the request component identified by <code>FieldToMatch</code>, starting
         * from the lowest priority setting, before inspecting the content for a match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TextTransformation>.Builder} avoiding the
         * need to create one manually via {@link List<TextTransformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TextTransformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #textTransformations(List<TextTransformation>)}.
         * 
         * @param textTransformations
         *        a consumer that will call methods on {@link List<TextTransformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textTransformations(List<TextTransformation>)
         */
        Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private FieldToMatch fieldToMatch;

        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSetReferenceStatement model) {
            arn(model.arn);
            fieldToMatch(model.fieldToMatch);
            textTransformations(model.textTransformations);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return fieldToMatch != null ? fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final Collection<TextTransformation.Builder> getTextTransformations() {
            if (textTransformations instanceof SdkAutoConstructList) {
                return null;
            }
            return textTransformations != null ? textTransformations.stream().map(TextTransformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation... textTransformations) {
            textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder>... textTransformations) {
            textTransformations(Stream.of(textTransformations).map(c -> TextTransformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        @Override
        public RegexPatternSetReferenceStatement build() {
            return new RegexPatternSetReferenceStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
