/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address
 * that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
 * any header name.
 * </p>
 * <note>
 * <p>
 * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
 * </p>
 * </note>
 * <p>
 * This configuration is used only for <a>IPSetReferenceStatement</a>. For <a>GeoMatchStatement</a> and
 * <a>RateBasedStatement</a>, use <a>ForwardedIPConfig</a> instead.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPSetForwardedIPConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IPSetForwardedIPConfig.Builder, IPSetForwardedIPConfig> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HeaderName").getter(getter(IPSetForwardedIPConfig::headerName)).setter(setter(Builder::headerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderName").build()).build();

    private static final SdkField<String> FALLBACK_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackBehavior").getter(getter(IPSetForwardedIPConfig::fallbackBehaviorAsString))
            .setter(setter(Builder::fallbackBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackBehavior").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(IPSetForwardedIPConfig::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD,
            FALLBACK_BEHAVIOR_FIELD, POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String headerName;

    private final String fallbackBehavior;

    private final String position;

    private IPSetForwardedIPConfig(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.fallbackBehavior = builder.fallbackBehavior;
        this.position = builder.position;
    }

    /**
     * <p>
     * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set
     * this to <code>X-Forwarded-For</code>.
     * </p>
     * <note>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * </p>
     * </note>
     * 
     * @return The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF)
     *         header, set this to <code>X-Forwarded-For</code>.</p> <note>
     *         <p>
     *         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request
     *         at all.
     *         </p>
     */
    public final String headerName() {
        return headerName;
    }

    /**
     * <p>
     * The match status to assign to the web request if the request doesn't have a valid IP address in the specified
     * position.
     * </p>
     * <note>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * </p>
     * </note>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if the request doesn't have a valid IP address in the
     *         specified position.</p> <note>
     *         <p>
     *         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request
     *         at all.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule
     *         action to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final FallbackBehavior fallbackBehavior() {
        return FallbackBehavior.fromValue(fallbackBehavior);
    }

    /**
     * <p>
     * The match status to assign to the web request if the request doesn't have a valid IP address in the specified
     * position.
     * </p>
     * <note>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * </p>
     * </note>
     * <p>
     * You can specify the following fallback behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackBehavior}
     * will return {@link FallbackBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackBehaviorAsString}.
     * </p>
     * 
     * @return The match status to assign to the web request if the request doesn't have a valid IP address in the
     *         specified position.</p> <note>
     *         <p>
     *         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request
     *         at all.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify the following fallback behaviors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule
     *         action to the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
     *         </p>
     *         </li>
     * @see FallbackBehavior
     */
    public final String fallbackBehaviorAsString() {
        return fallbackBehavior;
    }

    /**
     * <p>
     * The position in the header to search for the IP address. The header can contain IP addresses of the original
     * client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code>
     * where the first IP address identifies the original client and the rest identify proxies that the request went
     * through.
     * </p>
     * <p>
     * The options for this setting are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's
     * original IP.
     * </p>
     * </li>
     * <li>
     * <p>
     * LAST - Inspect the last IP address in the list of IP addresses in the header.
     * </p>
     * </li>
     * <li>
     * <p>
     * ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS
     * WAF inspects the last 10.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link ForwardedIPPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return The position in the header to search for the IP address. The header can contain IP addresses of the
     *         original client and also of proxies. For example, the header value could be
     *         <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client
     *         and the rest identify proxies that the request went through. </p>
     *         <p>
     *         The options for this setting are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the
     *         client's original IP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LAST - Inspect the last IP address in the list of IP addresses in the header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP
     *         addresses, AWS WAF inspects the last 10.
     *         </p>
     *         </li>
     * @see ForwardedIPPosition
     */
    public final ForwardedIPPosition position() {
        return ForwardedIPPosition.fromValue(position);
    }

    /**
     * <p>
     * The position in the header to search for the IP address. The header can contain IP addresses of the original
     * client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code>
     * where the first IP address identifies the original client and the rest identify proxies that the request went
     * through.
     * </p>
     * <p>
     * The options for this setting are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's
     * original IP.
     * </p>
     * </li>
     * <li>
     * <p>
     * LAST - Inspect the last IP address in the list of IP addresses in the header.
     * </p>
     * </li>
     * <li>
     * <p>
     * ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS
     * WAF inspects the last 10.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link ForwardedIPPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return The position in the header to search for the IP address. The header can contain IP addresses of the
     *         original client and also of proxies. For example, the header value could be
     *         <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client
     *         and the rest identify proxies that the request went through. </p>
     *         <p>
     *         The options for this setting are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the
     *         client's original IP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LAST - Inspect the last IP address in the list of IP addresses in the header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP
     *         addresses, AWS WAF inspects the last 10.
     *         </p>
     *         </li>
     * @see ForwardedIPPosition
     */
    public final String positionAsString() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetForwardedIPConfig)) {
            return false;
        }
        IPSetForwardedIPConfig other = (IPSetForwardedIPConfig) obj;
        return Objects.equals(headerName(), other.headerName())
                && Objects.equals(fallbackBehaviorAsString(), other.fallbackBehaviorAsString())
                && Objects.equals(positionAsString(), other.positionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPSetForwardedIPConfig").add("HeaderName", headerName())
                .add("FallbackBehavior", fallbackBehaviorAsString()).add("Position", positionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderName":
            return Optional.ofNullable(clazz.cast(headerName()));
        case "FallbackBehavior":
            return Optional.ofNullable(clazz.cast(fallbackBehaviorAsString()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSetForwardedIPConfig, T> g) {
        return obj -> g.apply((IPSetForwardedIPConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPSetForwardedIPConfig> {
        /**
         * <p>
         * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header,
         * set this to <code>X-Forwarded-For</code>.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at
         * all.
         * </p>
         * </note>
         * 
         * @param headerName
         *        The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF)
         *        header, set this to <code>X-Forwarded-For</code>.</p> <note>
         *        <p>
         *        If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web
         *        request at all.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified
         * position.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at
         * all.
         * </p>
         * </note>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to
         * the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if the request doesn't have a valid IP address in the
         *        specified position.</p> <note>
         *        <p>
         *        If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web
         *        request at all.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule
         *        action to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(String fallbackBehavior);

        /**
         * <p>
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified
         * position.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at
         * all.
         * </p>
         * </note>
         * <p>
         * You can specify the following fallback behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to
         * the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fallbackBehavior
         *        The match status to assign to the web request if the request doesn't have a valid IP address in the
         *        specified position.</p> <note>
         *        <p>
         *        If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web
         *        request at all.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify the following fallback behaviors:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule
         *        action to the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.
         *        </p>
         *        </li>
         * @see FallbackBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackBehavior
         */
        Builder fallbackBehavior(FallbackBehavior fallbackBehavior);

        /**
         * <p>
         * The position in the header to search for the IP address. The header can contain IP addresses of the original
         * client and also of proxies. For example, the header value could be
         * <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and
         * the rest identify proxies that the request went through.
         * </p>
         * <p>
         * The options for this setting are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's
         * original IP.
         * </p>
         * </li>
         * <li>
         * <p>
         * LAST - Inspect the last IP address in the list of IP addresses in the header.
         * </p>
         * </li>
         * <li>
         * <p>
         * ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses,
         * AWS WAF inspects the last 10.
         * </p>
         * </li>
         * </ul>
         * 
         * @param position
         *        The position in the header to search for the IP address. The header can contain IP addresses of the
         *        original client and also of proxies. For example, the header value could be
         *        <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original
         *        client and the rest identify proxies that the request went through. </p>
         *        <p>
         *        The options for this setting are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the
         *        client's original IP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LAST - Inspect the last IP address in the list of IP addresses in the header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP
         *        addresses, AWS WAF inspects the last 10.
         *        </p>
         *        </li>
         * @see ForwardedIPPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardedIPPosition
         */
        Builder position(String position);

        /**
         * <p>
         * The position in the header to search for the IP address. The header can contain IP addresses of the original
         * client and also of proxies. For example, the header value could be
         * <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and
         * the rest identify proxies that the request went through.
         * </p>
         * <p>
         * The options for this setting are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's
         * original IP.
         * </p>
         * </li>
         * <li>
         * <p>
         * LAST - Inspect the last IP address in the list of IP addresses in the header.
         * </p>
         * </li>
         * <li>
         * <p>
         * ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses,
         * AWS WAF inspects the last 10.
         * </p>
         * </li>
         * </ul>
         * 
         * @param position
         *        The position in the header to search for the IP address. The header can contain IP addresses of the
         *        original client and also of proxies. For example, the header value could be
         *        <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original
         *        client and the rest identify proxies that the request went through. </p>
         *        <p>
         *        The options for this setting are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the
         *        client's original IP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LAST - Inspect the last IP address in the list of IP addresses in the header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP
         *        addresses, AWS WAF inspects the last 10.
         *        </p>
         *        </li>
         * @see ForwardedIPPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardedIPPosition
         */
        Builder position(ForwardedIPPosition position);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String fallbackBehavior;

        private String position;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetForwardedIPConfig model) {
            headerName(model.headerName);
            fallbackBehavior(model.fallbackBehavior);
            position(model.position);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getFallbackBehavior() {
            return fallbackBehavior;
        }

        @Override
        public final Builder fallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
            return this;
        }

        @Override
        public final Builder fallbackBehavior(FallbackBehavior fallbackBehavior) {
            this.fallbackBehavior(fallbackBehavior == null ? null : fallbackBehavior.toString());
            return this;
        }

        public final void setFallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(ForwardedIPPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public IPSetForwardedIPConfig build() {
            return new IPSetForwardedIPConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
