/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.IPSetSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.IPSetSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIpSetsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListIpSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListIpSetsResponse.getter(ListIpSetsResponse::nextMarker)).setter(ListIpSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<IPSetSummary>> IP_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IPSets").getter(ListIpSetsResponse.getter(ListIpSetsResponse::ipSets)).setter(ListIpSetsResponse.setter(Builder::ipSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, IP_SETS_FIELD));
    private final String nextMarker;
    private final List<IPSetSummary> ipSets;

    private ListIpSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ipSets = builder.ipSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public boolean hasIpSets() {
        return this.ipSets != null && !(this.ipSets instanceof SdkAutoConstructList);
    }

    public List<IPSetSummary> ipSets() {
        return this.ipSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpSetsResponse)) {
            return false;
        }
        ListIpSetsResponse other = (ListIpSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.ipSets(), other.ipSets());
    }

    public String toString() {
        return ToString.builder((String)"ListIpSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("IPSets", this.ipSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "IPSets": {
                return Optional.ofNullable(clazz.cast(this.ipSets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpSetsResponse, T> g) {
        return obj -> g.apply((ListIpSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<IPSetSummary> ipSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.ipSets(model.ipSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<IPSetSummary.Builder> getIpSets() {
            return this.ipSets != null ? (Collection)this.ipSets.stream().map(IPSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IPSetSummary ... ipSets) {
            this.ipSets(Arrays.asList(ipSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(Consumer<IPSetSummary.Builder> ... ipSets) {
            this.ipSets(Stream.of(ipSets).map(c -> (IPSetSummary)((IPSetSummary.Builder)IPSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpSets(Collection<IPSetSummary.BuilderImpl> ipSets) {
            this.ipSets = IPSetSummariesCopier.copyFromBuilder(ipSets);
        }

        @Override
        public ListIpSetsResponse build() {
            return new ListIpSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIpSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder ipSets(Collection<IPSetSummary> var1);

        public Builder ipSets(IPSetSummary ... var1);

        public Builder ipSets(Consumer<IPSetSummary.Builder> ... var1);
    }
}

