/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FallbackBehavior {
    MATCH("MATCH"),
    NO_MATCH("NO_MATCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FallbackBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FallbackBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FallbackBehavior.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FallbackBehavior> knownValues() {
        return Stream.of(FallbackBehavior.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

