/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.LoggingConfiguration;
import software.amazon.awssdk.services.wafv2.model.LoggingConfigurationsCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLoggingConfigurationsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
    private static final SdkField<List<LoggingConfiguration>> LOGGING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoggingConfigurations").getter(ListLoggingConfigurationsResponse.getter(ListLoggingConfigurationsResponse::loggingConfigurations)).setter(ListLoggingConfigurationsResponse.setter(Builder::loggingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListLoggingConfigurationsResponse.getter(ListLoggingConfigurationsResponse::nextMarker)).setter(ListLoggingConfigurationsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIGURATIONS_FIELD, NEXT_MARKER_FIELD));
    private final List<LoggingConfiguration> loggingConfigurations;
    private final String nextMarker;

    private ListLoggingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfigurations = builder.loggingConfigurations;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasLoggingConfigurations() {
        return this.loggingConfigurations != null && !(this.loggingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LoggingConfiguration> loggingConfigurations() {
        return this.loggingConfigurations;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurations() ? this.loggingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoggingConfigurationsResponse)) {
            return false;
        }
        ListLoggingConfigurationsResponse other = (ListLoggingConfigurationsResponse)((Object)obj);
        return this.hasLoggingConfigurations() == other.hasLoggingConfigurations() && Objects.equals(this.loggingConfigurations(), other.loggingConfigurations()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListLoggingConfigurationsResponse").add("LoggingConfigurations", this.hasLoggingConfigurations() ? this.loggingConfigurations() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoggingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurations()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLoggingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListLoggingConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private List<LoggingConfiguration> loggingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoggingConfigurationsResponse model) {
            super(model);
            this.loggingConfigurations(model.loggingConfigurations);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<LoggingConfiguration.Builder> getLoggingConfigurations() {
            if (this.loggingConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loggingConfigurations != null ? (Collection)this.loggingConfigurations.stream().map(LoggingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggingConfigurations(Collection<LoggingConfiguration> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationsCopier.copy(loggingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(LoggingConfiguration ... loggingConfigurations) {
            this.loggingConfigurations(Arrays.asList(loggingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(Consumer<LoggingConfiguration.Builder> ... loggingConfigurations) {
            this.loggingConfigurations(Stream.of(loggingConfigurations).map(c -> (LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoggingConfigurations(Collection<LoggingConfiguration.BuilderImpl> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationsCopier.copyFromBuilder(loggingConfigurations);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListLoggingConfigurationsResponse build() {
            return new ListLoggingConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
        public Builder loggingConfigurations(Collection<LoggingConfiguration> var1);

        public Builder loggingConfigurations(LoggingConfiguration ... var1);

        public Builder loggingConfigurations(Consumer<LoggingConfiguration.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

