/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IPAddressVersion {
    IPV4("IPV4"),
    IPV6("IPV6"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IPAddressVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IPAddressVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IPAddressVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IPAddressVersion> knownValues() {
        return Stream.of(IPAddressVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

