/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.HTTPHeader;
import software.amazon.awssdk.services.wafv2.model.HTTPHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HTTPRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HTTPRequest> {
    private static final SdkField<String> CLIENT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientIP").getter(HTTPRequest.getter(HTTPRequest::clientIP)).setter(HTTPRequest.setter(Builder::clientIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIP").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(HTTPRequest.getter(HTTPRequest::country)).setter(HTTPRequest.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("URI").getter(HTTPRequest.getter(HTTPRequest::uri)).setter(HTTPRequest.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(HTTPRequest.getter(HTTPRequest::method)).setter(HTTPRequest.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HTTPVersion").getter(HTTPRequest.getter(HTTPRequest::httpVersion)).setter(HTTPRequest.setter(Builder::httpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPVersion").build()}).build();
    private static final SdkField<List<HTTPHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Headers").getter(HTTPRequest.getter(HTTPRequest::headers)).setter(HTTPRequest.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HTTPHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IP_FIELD, COUNTRY_FIELD, URI_FIELD, METHOD_FIELD, HTTP_VERSION_FIELD, HEADERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientIP;
    private final String country;
    private final String uri;
    private final String method;
    private final String httpVersion;
    private final List<HTTPHeader> headers;

    private HTTPRequest(BuilderImpl builder) {
        this.clientIP = builder.clientIP;
        this.country = builder.country;
        this.uri = builder.uri;
        this.method = builder.method;
        this.httpVersion = builder.httpVersion;
        this.headers = builder.headers;
    }

    public String clientIP() {
        return this.clientIP;
    }

    public String country() {
        return this.country;
    }

    public String uri() {
        return this.uri;
    }

    public String method() {
        return this.method;
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public List<HTTPHeader> headers() {
        return this.headers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest other = (HTTPRequest)obj;
        return Objects.equals(this.clientIP(), other.clientIP()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.method(), other.method()) && Objects.equals(this.httpVersion(), other.httpVersion()) && Objects.equals(this.headers(), other.headers());
    }

    public String toString() {
        return ToString.builder((String)"HTTPRequest").add("ClientIP", (Object)this.clientIP()).add("Country", (Object)this.country()).add("URI", (Object)this.uri()).add("Method", (Object)this.method()).add("HTTPVersion", (Object)this.httpVersion()).add("Headers", this.headers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientIP": {
                return Optional.ofNullable(clazz.cast(this.clientIP()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "URI": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "HTTPVersion": {
                return Optional.ofNullable(clazz.cast(this.httpVersion()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HTTPRequest, T> g) {
        return obj -> g.apply((HTTPRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientIP;
        private String country;
        private String uri;
        private String method;
        private String httpVersion;
        private List<HTTPHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HTTPRequest model) {
            this.clientIP(model.clientIP);
            this.country(model.country);
            this.uri(model.uri);
            this.method(model.method);
            this.httpVersion(model.httpVersion);
            this.headers(model.headers);
        }

        public final String getClientIP() {
            return this.clientIP;
        }

        @Override
        public final Builder clientIP(String clientIP) {
            this.clientIP = clientIP;
            return this;
        }

        public final void setClientIP(String clientIP) {
            this.clientIP = clientIP;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMethod() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getHttpVersion() {
            return this.httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Collection<HTTPHeader.Builder> getHeaders() {
            return this.headers != null ? (Collection)this.headers.stream().map(HTTPHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder headers(Collection<HTTPHeader> headers) {
            this.headers = HTTPHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HTTPHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HTTPHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (HTTPHeader)((HTTPHeader.Builder)HTTPHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHeaders(Collection<HTTPHeader.BuilderImpl> headers) {
            this.headers = HTTPHeadersCopier.copyFromBuilder(headers);
        }

        public HTTPRequest build() {
            return new HTTPRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HTTPRequest> {
        public Builder clientIP(String var1);

        public Builder country(String var1);

        public Builder uri(String var1);

        public Builder method(String var1);

        public Builder httpVersion(String var1);

        public Builder headers(Collection<HTTPHeader> var1);

        public Builder headers(HTTPHeader ... var1);

        public Builder headers(Consumer<HTTPHeader.Builder> ... var1);
    }
}

