/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.RuleSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.RuleSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedRuleGroupResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, DescribeManagedRuleGroupResponse> {
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::capacity)).setter(DescribeManagedRuleGroupResponse.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<List<RuleSummary>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(DescribeManagedRuleGroupResponse.getter(DescribeManagedRuleGroupResponse::rules)).setter(DescribeManagedRuleGroupResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, RULES_FIELD));
    private final Long capacity;
    private final List<RuleSummary> rules;

    private DescribeManagedRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.rules = builder.rules;
    }

    public Long capacity() {
        return this.capacity;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<RuleSummary> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedRuleGroupResponse)) {
            return false;
        }
        DescribeManagedRuleGroupResponse other = (DescribeManagedRuleGroupResponse)((Object)obj);
        return Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"DescribeManagedRuleGroupResponse").add("Capacity", (Object)this.capacity()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedRuleGroupResponse, T> g) {
        return obj -> g.apply((DescribeManagedRuleGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private Long capacity;
        private List<RuleSummary> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedRuleGroupResponse model) {
            super(model);
            this.capacity(model.capacity);
            this.rules(model.rules);
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        public final Collection<RuleSummary.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(RuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleSummary.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleSummary)((RuleSummary.Builder)RuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        @Override
        public DescribeManagedRuleGroupResponse build() {
            return new DescribeManagedRuleGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedRuleGroupResponse> {
        public Builder capacity(Long var1);

        public Builder rules(Collection<RuleSummary> var1);

        public Builder rules(RuleSummary ... var1);

        public Builder rules(Consumer<RuleSummary.Builder> ... var1);
    }
}

