/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Statement;
import software.amazon.awssdk.services.wafv2.model.StatementsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AndStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AndStatement> {
    private static final SdkField<List<Statement>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statements").getter(AndStatement.getter(AndStatement::statements)).setter(AndStatement.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Statement> statements;

    private AndStatement(BuilderImpl builder) {
        this.statements = builder.statements;
    }

    public boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public List<Statement> statements() {
        return this.statements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AndStatement)) {
            return false;
        }
        AndStatement other = (AndStatement)obj;
        return Objects.equals(this.statements(), other.statements());
    }

    public String toString() {
        return ToString.builder((String)"AndStatement").add("Statements", this.statements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AndStatement, T> g) {
        return obj -> g.apply((AndStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Statement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AndStatement model) {
            this.statements(model.statements);
        }

        public final Collection<Statement.Builder> getStatements() {
            return this.statements != null ? (Collection)this.statements.stream().map(Statement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<Statement> statements) {
            this.statements = StatementsCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Statement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<Statement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (Statement)((Statement.Builder)Statement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<Statement.BuilderImpl> statements) {
            this.statements = StatementsCopier.copyFromBuilder(statements);
        }

        public AndStatement build() {
            return new AndStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AndStatement> {
        public Builder statements(Collection<Statement> var1);

        public Builder statements(Statement ... var1);

        public Builder statements(Consumer<Statement.Builder> ... var1);
    }
}

