/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAclResponse extends Wafv2Response implements
        ToCopyableBuilder<UpdateWebAclResponse.Builder, UpdateWebAclResponse> {
    private static final SdkField<String> NEXT_LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateWebAclResponse::nextLockToken)).setter(setter(Builder::nextLockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextLockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_LOCK_TOKEN_FIELD));

    private final String nextLockToken;

    private UpdateWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.nextLockToken = builder.nextLockToken;
    }

    /**
     * <p>
     * A token used for optimistic locking. AWS WAF returns this token to your update requests. You use
     * <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>.
     * </p>
     * 
     * @return A token used for optimistic locking. AWS WAF returns this token to your update requests. You use
     *         <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>.
     */
    public String nextLockToken() {
        return nextLockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextLockToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAclResponse)) {
            return false;
        }
        UpdateWebAclResponse other = (UpdateWebAclResponse) obj;
        return Objects.equals(nextLockToken(), other.nextLockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateWebAclResponse").add("NextLockToken", nextLockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextLockToken":
            return Optional.ofNullable(clazz.cast(nextLockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAclResponse, T> g) {
        return obj -> g.apply((UpdateWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebAclResponse> {
        /**
         * <p>
         * A token used for optimistic locking. AWS WAF returns this token to your update requests. You use
         * <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>.
         * </p>
         * 
         * @param nextLockToken
         *        A token used for optimistic locking. AWS WAF returns this token to your update requests. You use
         *        <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextLockToken(String nextLockToken);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextLockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAclResponse model) {
            super(model);
            nextLockToken(model.nextLockToken);
        }

        public final String getNextLockToken() {
            return nextLockToken;
        }

        @Override
        public final Builder nextLockToken(String nextLockToken) {
            this.nextLockToken = nextLockToken;
            return this;
        }

        public final void setNextLockToken(String nextLockToken) {
            this.nextLockToken = nextLockToken;
        }

        @Override
        public UpdateWebAclResponse build() {
            return new UpdateWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
