/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallManagerRuleGroupsResponse extends Wafv2Response implements
        ToCopyableBuilder<DeleteFirewallManagerRuleGroupsResponse.Builder, DeleteFirewallManagerRuleGroupsResponse> {
    private static final SdkField<String> NEXT_WEB_ACL_LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteFirewallManagerRuleGroupsResponse::nextWebACLLockToken))
            .setter(setter(Builder::nextWebACLLockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextWebACLLockToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NEXT_WEB_ACL_LOCK_TOKEN_FIELD));

    private final String nextWebACLLockToken;

    private DeleteFirewallManagerRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextWebACLLockToken = builder.nextWebACLLockToken;
    }

    /**
     * <p>
     * A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the state of
     * the entity at the time of the request. To make changes to the entity associated with the token, you provide the
     * token to operations like update and delete. AWS WAF uses the token to ensure that no changes have been made to
     * the entity since you last retrieved it. If a change has been made, the update fails with a
     * <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the new token returned by
     * that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the
     *         state of the entity at the time of the request. To make changes to the entity associated with the token,
     *         you provide the token to operations like update and delete. AWS WAF uses the token to ensure that no
     *         changes have been made to the entity since you last retrieved it. If a change has been made, the update
     *         fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the
     *         new token returned by that operation.
     */
    public String nextWebACLLockToken() {
        return nextWebACLLockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextWebACLLockToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallManagerRuleGroupsResponse)) {
            return false;
        }
        DeleteFirewallManagerRuleGroupsResponse other = (DeleteFirewallManagerRuleGroupsResponse) obj;
        return Objects.equals(nextWebACLLockToken(), other.nextWebACLLockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFirewallManagerRuleGroupsResponse").add("NextWebACLLockToken", nextWebACLLockToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextWebACLLockToken":
            return Optional.ofNullable(clazz.cast(nextWebACLLockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallManagerRuleGroupsResponse, T> g) {
        return obj -> g.apply((DeleteFirewallManagerRuleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteFirewallManagerRuleGroupsResponse> {
        /**
         * <p>
         * A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark the state
         * of the entity at the time of the request. To make changes to the entity associated with the token, you
         * provide the token to operations like update and delete. AWS WAF uses the token to ensure that no changes have
         * been made to the entity since you last retrieved it. If a change has been made, the update fails with a
         * <code>WAFOptimisticLockException</code>. If this happens, perform another get, and use the new token returned
         * by that operation.
         * </p>
         * 
         * @param nextWebACLLockToken
         *        A token used for optimistic locking. AWS WAF returns a token to your get and list requests, to mark
         *        the state of the entity at the time of the request. To make changes to the entity associated with the
         *        token, you provide the token to operations like update and delete. AWS WAF uses the token to ensure
         *        that no changes have been made to the entity since you last retrieved it. If a change has been made,
         *        the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another get,
         *        and use the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextWebACLLockToken(String nextWebACLLockToken);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextWebACLLockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallManagerRuleGroupsResponse model) {
            super(model);
            nextWebACLLockToken(model.nextWebACLLockToken);
        }

        public final String getNextWebACLLockToken() {
            return nextWebACLLockToken;
        }

        @Override
        public final Builder nextWebACLLockToken(String nextWebACLLockToken) {
            this.nextWebACLLockToken = nextWebACLLockToken;
            return this;
        }

        public final void setNextWebACLLockToken(String nextWebACLLockToken) {
            this.nextWebACLLockToken = nextWebACLLockToken;
        }

        @Override
        public DeleteFirewallManagerRuleGroupsResponse build() {
            return new DeleteFirewallManagerRuleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
