/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.ParameterExceptionField;
import software.amazon.awssdk.services.wafv2.model.Wafv2Exception;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WafInvalidParameterException
extends Wafv2Exception
implements ToCopyableBuilder<Builder, WafInvalidParameterException> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WafInvalidParameterException.getter(WafInvalidParameterException::fieldAsString)).setter(WafInvalidParameterException.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<String> PARAMETER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WafInvalidParameterException.getter(WafInvalidParameterException::parameter)).setter(WafInvalidParameterException.setter(Builder::parameter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WafInvalidParameterException.getter(WafInvalidParameterException::reason)).setter(WafInvalidParameterException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, PARAMETER_FIELD, REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String field;
    private final String parameter;
    private final String reason;

    private WafInvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.field = builder.field;
        this.parameter = builder.parameter;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ParameterExceptionField field() {
        return ParameterExceptionField.fromValue(this.field);
    }

    public String fieldAsString() {
        return this.field;
    }

    public String parameter() {
        return this.parameter;
    }

    public String reason() {
        return this.reason;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WafInvalidParameterException, T> g) {
        return obj -> g.apply((WafInvalidParameterException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Exception.BuilderImpl
    implements Builder {
        private String field;
        private String parameter;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WafInvalidParameterException model) {
            super(model);
            this.field(model.field);
            this.parameter(model.parameter);
            this.reason(model.reason);
        }

        public final String getFieldAsString() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(ParameterExceptionField field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final String getParameter() {
            return this.parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public WafInvalidParameterException build() {
            return new WafInvalidParameterException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WafInvalidParameterException>,
    Wafv2Exception.Builder {
        public Builder field(String var1);

        public Builder field(ParameterExceptionField var1);

        public Builder parameter(String var1);

        public Builder reason(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

