/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebAclForResourceResponse extends Wafv2Response implements
        ToCopyableBuilder<GetWebAclForResourceResponse.Builder, GetWebAclForResourceResponse> {
    private static final SdkField<WebACL> WEB_ACL_FIELD = SdkField.<WebACL> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetWebAclForResourceResponse::webACL)).setter(setter(Builder::webACL)).constructor(WebACL::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD));

    private final WebACL webACL;

    private GetWebAclForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.webACL = builder.webACL;
    }

    /**
     * <p>
     * The Web ACL that is associated with the resource. If there is no associated resource, AWS WAF returns a null Web
     * ACL.
     * </p>
     * 
     * @return The Web ACL that is associated with the resource. If there is no associated resource, AWS WAF returns a
     *         null Web ACL.
     */
    public WebACL webACL() {
        return webACL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclForResourceResponse)) {
            return false;
        }
        GetWebAclForResourceResponse other = (GetWebAclForResourceResponse) obj;
        return Objects.equals(webACL(), other.webACL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWebAclForResourceResponse").add("WebACL", webACL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACL":
            return Optional.ofNullable(clazz.cast(webACL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclForResourceResponse, T> g) {
        return obj -> g.apply((GetWebAclForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetWebAclForResourceResponse> {
        /**
         * <p>
         * The Web ACL that is associated with the resource. If there is no associated resource, AWS WAF returns a null
         * Web ACL.
         * </p>
         * 
         * @param webACL
         *        The Web ACL that is associated with the resource. If there is no associated resource, AWS WAF returns
         *        a null Web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACL(WebACL webACL);

        /**
         * <p>
         * The Web ACL that is associated with the resource. If there is no associated resource, AWS WAF returns a null
         * Web ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link WebACL.Builder} avoiding the need to create one
         * manually via {@link WebACL#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebACL.Builder#build()} is called immediately and its result is
         * passed to {@link #webACL(WebACL)}.
         * 
         * @param webACL
         *        a consumer that will call methods on {@link WebACL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACL(WebACL)
         */
        default Builder webACL(Consumer<WebACL.Builder> webACL) {
            return webACL(WebACL.builder().applyMutation(webACL).build());
        }
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private WebACL webACL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclForResourceResponse model) {
            super(model);
            webACL(model.webACL);
        }

        public final WebACL.Builder getWebACL() {
            return webACL != null ? webACL.toBuilder() : null;
        }

        @Override
        public final Builder webACL(WebACL webACL) {
            this.webACL = webACL;
            return this;
        }

        public final void setWebACL(WebACL.BuilderImpl webACL) {
            this.webACL = webACL != null ? webACL.build() : null;
        }

        @Override
        public GetWebAclForResourceResponse build() {
            return new GetWebAclForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
