/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is the latest version of <b>AWS WAF</b>, named AWS WAFV2, released in November, 2019. For information, including
 * how to migrate your AWS WAF resources from the prior release, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * A rule statement used to identify web requests based on country of origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoMatchStatement.Builder, GeoMatchStatement> {
    private static final SdkField<List<String>> COUNTRY_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GeoMatchStatement::countryCodesAsStrings))
            .setter(setter(Builder::countryCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> countryCodes;

    private GeoMatchStatement(BuilderImpl builder) {
        this.countryCodes = builder.countryCodes;
    }

    /**
     * <p>
     * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO
     * codes of the ISO 3166 international standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCountryCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
     *         country ISO codes of the ISO 3166 international standard.
     */
    public List<CountryCode> countryCodes() {
        return CountryCodesCopier.copyStringToEnum(countryCodes);
    }

    /**
     * Returns true if the CountryCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCountryCodes() {
        return countryCodes != null && !(countryCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO
     * codes of the ISO 3166 international standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCountryCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
     *         country ISO codes of the ISO 3166 international standard.
     */
    public List<String> countryCodesAsStrings() {
        return countryCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countryCodesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchStatement)) {
            return false;
        }
        GeoMatchStatement other = (GeoMatchStatement) obj;
        return Objects.equals(countryCodesAsStrings(), other.countryCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GeoMatchStatement").add("CountryCodes", countryCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountryCodes":
            return Optional.ofNullable(clazz.cast(countryCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchStatement, T> g) {
        return obj -> g.apply((GeoMatchStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchStatement> {
        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodesWithStrings(Collection<String> countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodesWithStrings(String... countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodes(Collection<CountryCode> countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodes(CountryCode... countryCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> countryCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchStatement model) {
            countryCodesWithStrings(model.countryCodes);
        }

        public final Collection<String> getCountryCodesAsStrings() {
            return countryCodes;
        }

        @Override
        public final Builder countryCodesWithStrings(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodesWithStrings(String... countryCodes) {
            countryCodesWithStrings(Arrays.asList(countryCodes));
            return this;
        }

        @Override
        public final Builder countryCodes(Collection<CountryCode> countryCodes) {
            this.countryCodes = CountryCodesCopier.copyEnumToString(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodes(CountryCode... countryCodes) {
            countryCodes(Arrays.asList(countryCodes));
            return this;
        }

        public final void setCountryCodesWithStrings(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
        }

        @Override
        public GeoMatchStatement build() {
            return new GeoMatchStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
