/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedRuleGroupRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, DescribeManagedRuleGroupRequest> {
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeManagedRuleGroupRequest.getter(DescribeManagedRuleGroupRequest::vendorName)).setter(DescribeManagedRuleGroupRequest.setter(Builder::vendorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeManagedRuleGroupRequest.getter(DescribeManagedRuleGroupRequest::name)).setter(DescribeManagedRuleGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeManagedRuleGroupRequest.getter(DescribeManagedRuleGroupRequest::scopeAsString)).setter(DescribeManagedRuleGroupRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_NAME_FIELD, NAME_FIELD, SCOPE_FIELD));
    private final String vendorName;
    private final String name;
    private final String scope;

    private DescribeManagedRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.vendorName = builder.vendorName;
        this.name = builder.name;
        this.scope = builder.scope;
    }

    public String vendorName() {
        return this.vendorName;
    }

    public String name() {
        return this.name;
    }

    public Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public String scopeAsString() {
        return this.scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedRuleGroupRequest)) {
            return false;
        }
        DescribeManagedRuleGroupRequest other = (DescribeManagedRuleGroupRequest)((Object)obj);
        return Objects.equals(this.vendorName(), other.vendorName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeAsString(), other.scopeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeManagedRuleGroupRequest").add("VendorName", (Object)this.vendorName()).add("Name", (Object)this.name()).add("Scope", (Object)this.scopeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VendorName": {
                return Optional.ofNullable(clazz.cast(this.vendorName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedRuleGroupRequest, T> g) {
        return obj -> g.apply((DescribeManagedRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String vendorName;
        private String name;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedRuleGroupRequest model) {
            super(model);
            this.vendorName(model.vendorName);
            this.name(model.name);
            this.scope(model.scope);
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScopeAsString() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeManagedRuleGroupRequest build() {
            return new DescribeManagedRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedRuleGroupRequest> {
        public Builder vendorName(String var1);

        public Builder name(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

