/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummariesCopier;
import software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscribedRuleGroupsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListSubscribedRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListSubscribedRuleGroupsResponse.getter(ListSubscribedRuleGroupsResponse::nextMarker)).setter(ListSubscribedRuleGroupsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<SubscribedRuleGroupSummary>> RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroups").getter(ListSubscribedRuleGroupsResponse.getter(ListSubscribedRuleGroupsResponse::ruleGroups)).setter(ListSubscribedRuleGroupsResponse.setter(Builder::ruleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedRuleGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, RULE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubscribedRuleGroupsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<SubscribedRuleGroupSummary> ruleGroups;

    private ListSubscribedRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ruleGroups = builder.ruleGroups;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasRuleGroups() {
        return this.ruleGroups != null && !(this.ruleGroups instanceof SdkAutoConstructList);
    }

    public final List<SubscribedRuleGroupSummary> ruleGroups() {
        return this.ruleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroups() ? this.ruleGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribedRuleGroupsResponse)) {
            return false;
        }
        ListSubscribedRuleGroupsResponse other = (ListSubscribedRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasRuleGroups() == other.hasRuleGroups() && Objects.equals(this.ruleGroups(), other.ruleGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubscribedRuleGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("RuleGroups", this.hasRuleGroups() ? this.ruleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("RuleGroups", RULE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscribedRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListSubscribedRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SubscribedRuleGroupSummary> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribedRuleGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.ruleGroups(model.ruleGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<SubscribedRuleGroupSummary.Builder> getRuleGroups() {
            List<SubscribedRuleGroupSummary.Builder> result = SubscribedRuleGroupSummariesCopier.copyToBuilder(this.ruleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroups(Collection<SubscribedRuleGroupSummary.BuilderImpl> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public final Builder ruleGroups(Collection<SubscribedRuleGroupSummary> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(SubscribedRuleGroupSummary ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (SubscribedRuleGroupSummary)((SubscribedRuleGroupSummary.Builder)SubscribedRuleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSubscribedRuleGroupsResponse build() {
            return new ListSubscribedRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscribedRuleGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder ruleGroups(Collection<SubscribedRuleGroupSummary> var1);

        public Builder ruleGroups(SubscribedRuleGroupSummary ... var1);

        public Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder> ... var1);
    }
}

