/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.RegexMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegexMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListRegexMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListRegexMatchSetsResponse.getter(ListRegexMatchSetsResponse::nextMarker)).setter(ListRegexMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<RegexMatchSetSummary>> REGEX_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegexMatchSets").getter(ListRegexMatchSetsResponse.getter(ListRegexMatchSetsResponse::regexMatchSets)).setter(ListRegexMatchSetsResponse.setter(Builder::regexMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegexMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, REGEX_MATCH_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegexMatchSetsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<RegexMatchSetSummary> regexMatchSets;

    private ListRegexMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexMatchSets = builder.regexMatchSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasRegexMatchSets() {
        return this.regexMatchSets != null && !(this.regexMatchSets instanceof SdkAutoConstructList);
    }

    public final List<RegexMatchSetSummary> regexMatchSets() {
        return this.regexMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexMatchSets() ? this.regexMatchSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexMatchSetsResponse)) {
            return false;
        }
        ListRegexMatchSetsResponse other = (ListRegexMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasRegexMatchSets() == other.hasRegexMatchSets() && Objects.equals(this.regexMatchSets(), other.regexMatchSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegexMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("RegexMatchSets", this.hasRegexMatchSets() ? this.regexMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RegexMatchSets": {
                return Optional.ofNullable(clazz.cast(this.regexMatchSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("RegexMatchSets", REGEX_MATCH_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegexMatchSetsResponse, T> g) {
        return obj -> g.apply((ListRegexMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RegexMatchSetSummary> regexMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.regexMatchSets(model.regexMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<RegexMatchSetSummary.Builder> getRegexMatchSets() {
            List<RegexMatchSetSummary.Builder> result = RegexMatchSetSummariesCopier.copyToBuilder(this.regexMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexMatchSets(Collection<RegexMatchSetSummary.BuilderImpl> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copyFromBuilder(regexMatchSets);
        }

        @Override
        public final Builder regexMatchSets(Collection<RegexMatchSetSummary> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copy(regexMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchSets(RegexMatchSetSummary ... regexMatchSets) {
            this.regexMatchSets(Arrays.asList(regexMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchSets(Consumer<RegexMatchSetSummary.Builder> ... regexMatchSets) {
            this.regexMatchSets(Stream.of(regexMatchSets).map(c -> (RegexMatchSetSummary)((RegexMatchSetSummary.Builder)RegexMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegexMatchSetsResponse build() {
            return new ListRegexMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegexMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder regexMatchSets(Collection<RegexMatchSetSummary> var1);

        public Builder regexMatchSets(RegexMatchSetSummary ... var1);

        public Builder regexMatchSets(Consumer<RegexMatchSetSummary.Builder> ... var1);
    }
}

