/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.regional;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.regional.DefaultWafRegionalAsyncClient;
import software.amazon.awssdk.services.waf.regional.DefaultWafRegionalBaseClientBuilder;
import software.amazon.awssdk.services.waf.regional.WafRegionalAsyncClient;
import software.amazon.awssdk.services.waf.regional.WafRegionalAsyncClientBuilder;
import software.amazon.awssdk.services.waf.regional.WafRegionalServiceClientConfiguration;
import software.amazon.awssdk.services.waf.regional.endpoints.WafRegionalEndpointProvider;

@SdkInternalApi
final class DefaultWafRegionalAsyncClientBuilder
extends DefaultWafRegionalBaseClientBuilder<WafRegionalAsyncClientBuilder, WafRegionalAsyncClient>
implements WafRegionalAsyncClientBuilder {
    DefaultWafRegionalAsyncClientBuilder() {
    }

    @Override
    public DefaultWafRegionalAsyncClientBuilder endpointProvider(WafRegionalEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WafRegionalAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWafRegionalAsyncClientBuilder.validateClientOptions(clientConfiguration);
        WafRegionalServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWafRegionalAsyncClient client = new DefaultWafRegionalAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WafRegionalServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WafRegionalServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

