/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.DefaultWafAsyncClient;
import software.amazon.awssdk.services.waf.DefaultWafBaseClientBuilder;
import software.amazon.awssdk.services.waf.WafAsyncClient;
import software.amazon.awssdk.services.waf.WafAsyncClientBuilder;
import software.amazon.awssdk.services.waf.WafServiceClientConfiguration;
import software.amazon.awssdk.services.waf.endpoints.WafEndpointProvider;

@SdkInternalApi
final class DefaultWafAsyncClientBuilder
extends DefaultWafBaseClientBuilder<WafAsyncClientBuilder, WafAsyncClient>
implements WafAsyncClientBuilder {
    DefaultWafAsyncClientBuilder() {
    }

    @Override
    public DefaultWafAsyncClientBuilder endpointProvider(WafEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WafAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWafAsyncClientBuilder.validateClientOptions(clientConfiguration);
        WafServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWafAsyncClient client = new DefaultWafAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WafServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WafServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

