/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Contains the identifier and the name of the <code>GeoMatchSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoMatchSetSummary.Builder, GeoMatchSetSummary> {
    private static final SdkField<String> GEO_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeoMatchSetId").getter(getter(GeoMatchSetSummary::geoMatchSetId)).setter(setter(Builder::geoMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GeoMatchSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_ID_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String geoMatchSetId;

    private final String name;

    private GeoMatchSetSummary(BuilderImpl builder) {
        this.geoMatchSetId = builder.geoMatchSetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The <code>GeoMatchSetId</code> for an <a>GeoMatchSet</a>. You can use <code>GeoMatchSetId</code> in a
     * <a>GetGeoMatchSet</a> request to get detailed information about an <a>GeoMatchSet</a>.
     * </p>
     * 
     * @return The <code>GeoMatchSetId</code> for an <a>GeoMatchSet</a>. You can use <code>GeoMatchSetId</code> in a
     *         <a>GetGeoMatchSet</a> request to get detailed information about an <a>GeoMatchSet</a>.
     */
    public final String geoMatchSetId() {
        return geoMatchSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
     * <code>GeoMatchSet</code> after you create it.
     * </p>
     * 
     * @return A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
     *         <code>GeoMatchSet</code> after you create it.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSetSummary)) {
            return false;
        }
        GeoMatchSetSummary other = (GeoMatchSetSummary) obj;
        return Objects.equals(geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoMatchSetSummary").add("GeoMatchSetId", geoMatchSetId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoMatchSetId":
            return Optional.ofNullable(clazz.cast(geoMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchSetSummary, T> g) {
        return obj -> g.apply((GeoMatchSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchSetSummary> {
        /**
         * <p>
         * The <code>GeoMatchSetId</code> for an <a>GeoMatchSet</a>. You can use <code>GeoMatchSetId</code> in a
         * <a>GetGeoMatchSet</a> request to get detailed information about an <a>GeoMatchSet</a>.
         * </p>
         * 
         * @param geoMatchSetId
         *        The <code>GeoMatchSetId</code> for an <a>GeoMatchSet</a>. You can use <code>GeoMatchSetId</code> in a
         *        <a>GetGeoMatchSet</a> request to get detailed information about an <a>GeoMatchSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSetId(String geoMatchSetId);

        /**
         * <p>
         * A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
         * <code>GeoMatchSet</code> after you create it.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>GeoMatchSet</a>. You can't change the name of an
         *        <code>GeoMatchSet</code> after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String geoMatchSetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSetSummary model) {
            geoMatchSetId(model.geoMatchSetId);
            name(model.name);
        }

        public final String getGeoMatchSetId() {
            return geoMatchSetId;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        @Override
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GeoMatchSetSummary build() {
            return new GeoMatchSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
