/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.SizeConstraint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SizeConstraintSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SizeConstraintSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SizeConstraintSetUpdate.getter(SizeConstraintSetUpdate::actionAsString)).setter(SizeConstraintSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<SizeConstraint> SIZE_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SizeConstraintSetUpdate.getter(SizeConstraintSetUpdate::sizeConstraint)).setter(SizeConstraintSetUpdate.setter(Builder::sizeConstraint)).constructor(SizeConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, SIZE_CONSTRAINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final SizeConstraint sizeConstraint;

    private SizeConstraintSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.sizeConstraint = builder.sizeConstraint;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public SizeConstraint sizeConstraint() {
        return this.sizeConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSetUpdate)) {
            return false;
        }
        SizeConstraintSetUpdate other = (SizeConstraintSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.sizeConstraint(), other.sizeConstraint());
    }

    public String toString() {
        return ToString.builder((String)"SizeConstraintSetUpdate").add("Action", (Object)this.actionAsString()).add("SizeConstraint", (Object)this.sizeConstraint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "SizeConstraint": {
                return Optional.ofNullable(clazz.cast(this.sizeConstraint()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintSetUpdate, T> g) {
        return obj -> g.apply((SizeConstraintSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private SizeConstraint sizeConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSetUpdate model) {
            this.action(model.action);
            this.sizeConstraint(model.sizeConstraint);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final SizeConstraint.Builder getSizeConstraint() {
            return this.sizeConstraint != null ? this.sizeConstraint.toBuilder() : null;
        }

        @Override
        public final Builder sizeConstraint(SizeConstraint sizeConstraint) {
            this.sizeConstraint = sizeConstraint;
            return this;
        }

        public final void setSizeConstraint(SizeConstraint.BuilderImpl sizeConstraint) {
            this.sizeConstraint = sizeConstraint != null ? sizeConstraint.build() : null;
        }

        public SizeConstraintSetUpdate build() {
            return new SizeConstraintSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SizeConstraintSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder sizeConstraint(SizeConstraint var1);

        default public Builder sizeConstraint(Consumer<SizeConstraint.Builder> sizeConstraint) {
            return this.sizeConstraint((SizeConstraint)((SizeConstraint.Builder)SizeConstraint.builder().applyMutation(sizeConstraint)).build());
        }
    }
}

