/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSqlInjectionMatchSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
    private static final SdkField<String> SQL_INJECTION_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlInjectionMatchSetId").getter(UpdateSqlInjectionMatchSetRequest.getter(UpdateSqlInjectionMatchSetRequest::sqlInjectionMatchSetId)).setter(UpdateSqlInjectionMatchSetRequest.setter(Builder::sqlInjectionMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSetId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateSqlInjectionMatchSetRequest.getter(UpdateSqlInjectionMatchSetRequest::changeToken)).setter(UpdateSqlInjectionMatchSetRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<SqlInjectionMatchSetUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateSqlInjectionMatchSetRequest.getter(UpdateSqlInjectionMatchSetRequest::updates)).setter(UpdateSqlInjectionMatchSetRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlInjectionMatchSetUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_INJECTION_MATCH_SET_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD));
    private final String sqlInjectionMatchSetId;
    private final String changeToken;
    private final List<SqlInjectionMatchSetUpdate> updates;

    private UpdateSqlInjectionMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public final String sqlInjectionMatchSetId() {
        return this.sqlInjectionMatchSetId;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<SqlInjectionMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSqlInjectionMatchSetRequest)) {
            return false;
        }
        UpdateSqlInjectionMatchSetRequest other = (UpdateSqlInjectionMatchSetRequest)((Object)obj);
        return Objects.equals(this.sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSqlInjectionMatchSetRequest").add("SqlInjectionMatchSetId", (Object)this.sqlInjectionMatchSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.hasUpdates() ? this.updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlInjectionMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSqlInjectionMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateSqlInjectionMatchSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String sqlInjectionMatchSetId;
        private String changeToken;
        private List<SqlInjectionMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSqlInjectionMatchSetRequest model) {
            super(model);
            this.sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getSqlInjectionMatchSetId() {
            return this.sqlInjectionMatchSetId;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        @Override
        @Transient
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<SqlInjectionMatchSetUpdate.Builder> getUpdates() {
            List<SqlInjectionMatchSetUpdate.Builder> result = SqlInjectionMatchSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<SqlInjectionMatchSetUpdate.BuilderImpl> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<SqlInjectionMatchSetUpdate> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(SqlInjectionMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<SqlInjectionMatchSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (SqlInjectionMatchSetUpdate)((SqlInjectionMatchSetUpdate.Builder)SqlInjectionMatchSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSqlInjectionMatchSetRequest build() {
            return new UpdateSqlInjectionMatchSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
        public Builder sqlInjectionMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SqlInjectionMatchSetUpdate> var1);

        public Builder updates(SqlInjectionMatchSetUpdate ... var1);

        public Builder updates(Consumer<SqlInjectionMatchSetUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

