/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.IPSet;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpSetResponse
extends WafResponse
implements ToCopyableBuilder<Builder, CreateIpSetResponse> {
    private static final SdkField<IPSet> IP_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IPSet").getter(CreateIpSetResponse.getter(CreateIpSetResponse::ipSet)).setter(CreateIpSetResponse.setter(Builder::ipSet)).constructor(IPSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSet").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(CreateIpSetResponse.getter(CreateIpSetResponse::changeToken)).setter(CreateIpSetResponse.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_FIELD, CHANGE_TOKEN_FIELD));
    private final IPSet ipSet;
    private final String changeToken;

    private CreateIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.ipSet = builder.ipSet;
        this.changeToken = builder.changeToken;
    }

    public final IPSet ipSet() {
        return this.ipSet;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetResponse)) {
            return false;
        }
        CreateIpSetResponse other = (CreateIpSetResponse)((Object)obj);
        return Objects.equals(this.ipSet(), other.ipSet()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpSetResponse").add("IPSet", (Object)this.ipSet()).add("ChangeToken", (Object)this.changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSet": {
                return Optional.ofNullable(clazz.cast(this.ipSet()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetResponse, T> g) {
        return obj -> g.apply((CreateIpSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private IPSet ipSet;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetResponse model) {
            super(model);
            this.ipSet(model.ipSet);
            this.changeToken(model.changeToken);
        }

        public final IPSet.Builder getIpSet() {
            return this.ipSet != null ? this.ipSet.toBuilder() : null;
        }

        public final void setIpSet(IPSet.BuilderImpl ipSet) {
            this.ipSet = ipSet != null ? ipSet.build() : null;
        }

        @Override
        public final Builder ipSet(IPSet ipSet) {
            this.ipSet = ipSet;
            return this;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public CreateIpSetResponse build() {
            return new CreateIpSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpSetResponse> {
        public Builder ipSet(IPSet var1);

        default public Builder ipSet(Consumer<IPSet.Builder> ipSet) {
            return this.ipSet((IPSet)((IPSet.Builder)IPSet.builder().applyMutation(ipSet)).build());
        }

        public Builder changeToken(String var1);
    }
}

