/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ActivatedRulesCopier;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActivatedRulesInRuleGroupResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListActivatedRulesInRuleGroupResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListActivatedRulesInRuleGroupResponse.getter(ListActivatedRulesInRuleGroupResponse::nextMarker)).setter(ListActivatedRulesInRuleGroupResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<ActivatedRule>> ACTIVATED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActivatedRules").getter(ListActivatedRulesInRuleGroupResponse.getter(ListActivatedRulesInRuleGroupResponse::activatedRules)).setter(ListActivatedRulesInRuleGroupResponse.setter(Builder::activatedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActivatedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, ACTIVATED_RULES_FIELD));
    private final String nextMarker;
    private final List<ActivatedRule> activatedRules;

    private ListActivatedRulesInRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.activatedRules = builder.activatedRules;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasActivatedRules() {
        return this.activatedRules != null && !(this.activatedRules instanceof SdkAutoConstructList);
    }

    public final List<ActivatedRule> activatedRules() {
        return this.activatedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivatedRules() ? this.activatedRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivatedRulesInRuleGroupResponse)) {
            return false;
        }
        ListActivatedRulesInRuleGroupResponse other = (ListActivatedRulesInRuleGroupResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasActivatedRules() == other.hasActivatedRules() && Objects.equals(this.activatedRules(), other.activatedRules());
    }

    public final String toString() {
        return ToString.builder((String)"ListActivatedRulesInRuleGroupResponse").add("NextMarker", (Object)this.nextMarker()).add("ActivatedRules", this.hasActivatedRules() ? this.activatedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "ActivatedRules": {
                return Optional.ofNullable(clazz.cast(this.activatedRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActivatedRulesInRuleGroupResponse, T> g) {
        return obj -> g.apply((ListActivatedRulesInRuleGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ActivatedRule> activatedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivatedRulesInRuleGroupResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.activatedRules(model.activatedRules);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ActivatedRule.Builder> getActivatedRules() {
            List<ActivatedRule.Builder> result = ActivatedRulesCopier.copyToBuilder(this.activatedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivatedRules(Collection<ActivatedRule.BuilderImpl> activatedRules) {
            this.activatedRules = ActivatedRulesCopier.copyFromBuilder(activatedRules);
        }

        @Override
        @Transient
        public final Builder activatedRules(Collection<ActivatedRule> activatedRules) {
            this.activatedRules = ActivatedRulesCopier.copy(activatedRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activatedRules(ActivatedRule ... activatedRules) {
            this.activatedRules(Arrays.asList(activatedRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder activatedRules(Consumer<ActivatedRule.Builder> ... activatedRules) {
            this.activatedRules(Stream.of(activatedRules).map(c -> (ActivatedRule)((ActivatedRule.Builder)ActivatedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListActivatedRulesInRuleGroupResponse build() {
            return new ListActivatedRulesInRuleGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActivatedRulesInRuleGroupResponse> {
        public Builder nextMarker(String var1);

        public Builder activatedRules(Collection<ActivatedRule> var1);

        public Builder activatedRules(ActivatedRule ... var1);

        public Builder activatedRules(Consumer<ActivatedRule.Builder> ... var1);
    }
}

