/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleGroupUpdate;
import software.amazon.awssdk.services.waf.model.RuleGroupUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRuleGroupRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupId").getter(UpdateRuleGroupRequest.getter(UpdateRuleGroupRequest::ruleGroupId)).setter(UpdateRuleGroupRequest.setter(Builder::ruleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()}).build();
    private static final SdkField<List<RuleGroupUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateRuleGroupRequest.getter(UpdateRuleGroupRequest::updates)).setter(UpdateRuleGroupRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateRuleGroupRequest.getter(UpdateRuleGroupRequest::changeToken)).setter(UpdateRuleGroupRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ID_FIELD, UPDATES_FIELD, CHANGE_TOKEN_FIELD));
    private final String ruleGroupId;
    private final List<RuleGroupUpdate> updates;
    private final String changeToken;

    private UpdateRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupId = builder.ruleGroupId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    public final String ruleGroupId() {
        return this.ruleGroupId;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupUpdate> updates() {
        return this.updates;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleGroupRequest)) {
            return false;
        }
        UpdateRuleGroupRequest other = (UpdateRuleGroupRequest)((Object)obj);
        return Objects.equals(this.ruleGroupId(), other.ruleGroupId()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRuleGroupRequest").add("RuleGroupId", (Object)this.ruleGroupId()).add("Updates", this.hasUpdates() ? this.updates() : null).add("ChangeToken", (Object)this.changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupId()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleGroupRequest, T> g) {
        return obj -> g.apply((UpdateRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String ruleGroupId;
        private List<RuleGroupUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleGroupRequest model) {
            super(model);
            this.ruleGroupId(model.ruleGroupId);
            this.updates(model.updates);
            this.changeToken(model.changeToken);
        }

        public final String getRuleGroupId() {
            return this.ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        @Transient
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final List<RuleGroupUpdate.Builder> getUpdates() {
            List<RuleGroupUpdate.Builder> result = RuleGroupUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<RuleGroupUpdate.BuilderImpl> updates) {
            this.updates = RuleGroupUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<RuleGroupUpdate> updates) {
            this.updates = RuleGroupUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(RuleGroupUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<RuleGroupUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RuleGroupUpdate)((RuleGroupUpdate.Builder)RuleGroupUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleGroupRequest build() {
            return new UpdateRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRuleGroupRequest> {
        public Builder ruleGroupId(String var1);

        public Builder updates(Collection<RuleGroupUpdate> var1);

        public Builder updates(RuleGroupUpdate ... var1);

        public Builder updates(Consumer<RuleGroupUpdate.Builder> ... var1);

        public Builder changeToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

