/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.PredicateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Predicate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Predicate> {
    private static final SdkField<Boolean> NEGATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Negated").getter(Predicate.getter(Predicate::negated)).setter(Predicate.setter(Builder::negated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negated").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Predicate.getter(Predicate::typeAsString)).setter(Predicate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DATA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataId").getter(Predicate.getter(Predicate::dataId)).setter(Predicate.setter(Builder::dataId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEGATED_FIELD, TYPE_FIELD, DATA_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean negated;
    private final String type;
    private final String dataId;

    private Predicate(BuilderImpl builder) {
        this.negated = builder.negated;
        this.type = builder.type;
        this.dataId = builder.dataId;
    }

    public final Boolean negated() {
        return this.negated;
    }

    public final PredicateType type() {
        return PredicateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String dataId() {
        return this.dataId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.negated());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return Objects.equals(this.negated(), other.negated()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.dataId(), other.dataId());
    }

    public final String toString() {
        return ToString.builder((String)"Predicate").add("Negated", (Object)this.negated()).add("Type", (Object)this.typeAsString()).add("DataId", (Object)this.dataId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Negated": {
                return Optional.ofNullable(clazz.cast(this.negated()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DataId": {
                return Optional.ofNullable(clazz.cast(this.dataId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean negated;
        private String type;
        private String dataId;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.negated(model.negated);
            this.type(model.type);
            this.dataId(model.dataId);
        }

        public final Boolean getNegated() {
            return this.negated;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        @Override
        @Transient
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(PredicateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDataId() {
            return this.dataId;
        }

        public final void setDataId(String dataId) {
            this.dataId = dataId;
        }

        @Override
        @Transient
        public final Builder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public Predicate build() {
            return new Predicate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Predicate> {
        public Builder negated(Boolean var1);

        public Builder type(String var1);

        public Builder type(PredicateType var1);

        public Builder dataId(String var1);
    }
}

