/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateXssMatchSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateXssMatchSetRequest> {
    private static final SdkField<String> XSS_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XssMatchSetId").getter(UpdateXssMatchSetRequest.getter(UpdateXssMatchSetRequest::xssMatchSetId)).setter(UpdateXssMatchSetRequest.setter(Builder::xssMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSetId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateXssMatchSetRequest.getter(UpdateXssMatchSetRequest::changeToken)).setter(UpdateXssMatchSetRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<XssMatchSetUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateXssMatchSetRequest.getter(UpdateXssMatchSetRequest::updates)).setter(UpdateXssMatchSetRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(XssMatchSetUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_MATCH_SET_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD));
    private final String xssMatchSetId;
    private final String changeToken;
    private final List<XssMatchSetUpdate> updates;

    private UpdateXssMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.xssMatchSetId = builder.xssMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public final String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<XssMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateXssMatchSetRequest)) {
            return false;
        }
        UpdateXssMatchSetRequest other = (UpdateXssMatchSetRequest)((Object)obj);
        return Objects.equals(this.xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateXssMatchSetRequest").add("XssMatchSetId", (Object)this.xssMatchSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.hasUpdates() ? this.updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "XssMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.xssMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateXssMatchSetRequest, T> g) {
        return obj -> g.apply((UpdateXssMatchSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String changeToken;
        private List<XssMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateXssMatchSetRequest model) {
            super(model);
            this.xssMatchSetId(model.xssMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final List<XssMatchSetUpdate.Builder> getUpdates() {
            List<XssMatchSetUpdate.Builder> result = XssMatchSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder updates(Collection<XssMatchSetUpdate> updates) {
            this.updates = XssMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(XssMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<XssMatchSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (XssMatchSetUpdate)((XssMatchSetUpdate.Builder)XssMatchSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<XssMatchSetUpdate.BuilderImpl> updates) {
            this.updates = XssMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateXssMatchSetRequest build() {
            return new UpdateXssMatchSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateXssMatchSetRequest> {
        public Builder xssMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<XssMatchSetUpdate> var1);

        public Builder updates(XssMatchSetUpdate ... var1);

        public Builder updates(Consumer<XssMatchSetUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

