/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSizeConstraintSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
    private static final SdkField<String> SIZE_CONSTRAINT_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizeConstraintSetId").getter(UpdateSizeConstraintSetRequest.getter(UpdateSizeConstraintSetRequest::sizeConstraintSetId)).setter(UpdateSizeConstraintSetRequest.setter(Builder::sizeConstraintSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSetId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateSizeConstraintSetRequest.getter(UpdateSizeConstraintSetRequest::changeToken)).setter(UpdateSizeConstraintSetRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<SizeConstraintSetUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateSizeConstraintSetRequest.getter(UpdateSizeConstraintSetRequest::updates)).setter(UpdateSizeConstraintSetRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SizeConstraintSetUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD));
    private final String sizeConstraintSetId;
    private final String changeToken;
    private final List<SizeConstraintSetUpdate> updates;

    private UpdateSizeConstraintSetRequest(BuilderImpl builder) {
        super(builder);
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public final String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<SizeConstraintSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSizeConstraintSetRequest)) {
            return false;
        }
        UpdateSizeConstraintSetRequest other = (UpdateSizeConstraintSetRequest)((Object)obj);
        return Objects.equals(this.sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSizeConstraintSetRequest").add("SizeConstraintSetId", (Object)this.sizeConstraintSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.hasUpdates() ? this.updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeConstraintSetId": {
                return Optional.ofNullable(clazz.cast(this.sizeConstraintSetId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSizeConstraintSetRequest, T> g) {
        return obj -> g.apply((UpdateSizeConstraintSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String changeToken;
        private List<SizeConstraintSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSizeConstraintSetRequest model) {
            super(model);
            this.sizeConstraintSetId(model.sizeConstraintSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final List<SizeConstraintSetUpdate.Builder> getUpdates() {
            List<SizeConstraintSetUpdate.Builder> result = SizeConstraintSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder updates(Collection<SizeConstraintSetUpdate> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SizeConstraintSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<SizeConstraintSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (SizeConstraintSetUpdate)((SizeConstraintSetUpdate.Builder)SizeConstraintSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<SizeConstraintSetUpdate.BuilderImpl> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSizeConstraintSetRequest build() {
            return new UpdateSizeConstraintSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
        public Builder sizeConstraintSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SizeConstraintSetUpdate> var1);

        public Builder updates(SizeConstraintSetUpdate ... var1);

        public Builder updates(Consumer<SizeConstraintSetUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

