/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexMatchTuple;
import software.amazon.awssdk.services.waf.model.RegexMatchTuplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexMatchSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegexMatchSet> {
    private static final SdkField<String> REGEX_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegexMatchSetId").getter(RegexMatchSet.getter(RegexMatchSet::regexMatchSetId)).setter(RegexMatchSet.setter(Builder::regexMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegexMatchSet.getter(RegexMatchSet::name)).setter(RegexMatchSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<RegexMatchTuple>> REGEX_MATCH_TUPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegexMatchTuples").getter(RegexMatchSet.getter(RegexMatchSet::regexMatchTuples)).setter(RegexMatchSet.setter(Builder::regexMatchTuples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchTuples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegexMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_ID_FIELD, NAME_FIELD, REGEX_MATCH_TUPLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regexMatchSetId;
    private final String name;
    private final List<RegexMatchTuple> regexMatchTuples;

    private RegexMatchSet(BuilderImpl builder) {
        this.regexMatchSetId = builder.regexMatchSetId;
        this.name = builder.name;
        this.regexMatchTuples = builder.regexMatchTuples;
    }

    public final String regexMatchSetId() {
        return this.regexMatchSetId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRegexMatchTuples() {
        return this.regexMatchTuples != null && !(this.regexMatchTuples instanceof SdkAutoConstructList);
    }

    public final List<RegexMatchTuple> regexMatchTuples() {
        return this.regexMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexMatchTuples() ? this.regexMatchTuples() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSet)) {
            return false;
        }
        RegexMatchSet other = (RegexMatchSet)obj;
        return Objects.equals(this.regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(this.name(), other.name()) && this.hasRegexMatchTuples() == other.hasRegexMatchTuples() && Objects.equals(this.regexMatchTuples(), other.regexMatchTuples());
    }

    public final String toString() {
        return ToString.builder((String)"RegexMatchSet").add("RegexMatchSetId", (Object)this.regexMatchSetId()).add("Name", (Object)this.name()).add("RegexMatchTuples", this.hasRegexMatchTuples() ? this.regexMatchTuples() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.regexMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegexMatchTuples": {
                return Optional.ofNullable(clazz.cast(this.regexMatchTuples()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchSet, T> g) {
        return obj -> g.apply((RegexMatchSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regexMatchSetId;
        private String name;
        private List<RegexMatchTuple> regexMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSet model) {
            this.regexMatchSetId(model.regexMatchSetId);
            this.name(model.name);
            this.regexMatchTuples(model.regexMatchTuples);
        }

        public final String getRegexMatchSetId() {
            return this.regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<RegexMatchTuple.Builder> getRegexMatchTuples() {
            if (this.regexMatchTuples instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regexMatchTuples != null ? (Collection)this.regexMatchTuples.stream().map(RegexMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regexMatchTuples(Collection<RegexMatchTuple> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copy(regexMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(RegexMatchTuple ... regexMatchTuples) {
            this.regexMatchTuples(Arrays.asList(regexMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder> ... regexMatchTuples) {
            this.regexMatchTuples(Stream.of(regexMatchTuples).map(c -> (RegexMatchTuple)((RegexMatchTuple.Builder)RegexMatchTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegexMatchTuples(Collection<RegexMatchTuple.BuilderImpl> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copyFromBuilder(regexMatchTuples);
        }

        public RegexMatchSet build() {
            return new RegexMatchSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegexMatchSet> {
        public Builder regexMatchSetId(String var1);

        public Builder name(String var1);

        public Builder regexMatchTuples(Collection<RegexMatchTuple> var1);

        public Builder regexMatchTuples(RegexMatchTuple ... var1);

        public Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder> ... var1);
    }
}

