/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ExcludedRule;
import software.amazon.awssdk.services.waf.model.ExcludedRulesCopier;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WafOverrideAction;
import software.amazon.awssdk.services.waf.model.WafRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivatedRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivatedRule> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(ActivatedRule.getter(ActivatedRule::priority)).setter(ActivatedRule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(ActivatedRule.getter(ActivatedRule::ruleId)).setter(ActivatedRule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<WafAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(ActivatedRule.getter(ActivatedRule::action)).setter(ActivatedRule.setter(Builder::action)).constructor(WafAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<WafOverrideAction> OVERRIDE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideAction").getter(ActivatedRule.getter(ActivatedRule::overrideAction)).setter(ActivatedRule.setter(Builder::overrideAction)).constructor(WafOverrideAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ActivatedRule.getter(ActivatedRule::typeAsString)).setter(ActivatedRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<ExcludedRule>> EXCLUDED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedRules").getter(ActivatedRule.getter(ActivatedRule::excludedRules)).setter(ActivatedRule.setter(Builder::excludedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExcludedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD, RULE_ID_FIELD, ACTION_FIELD, OVERRIDE_ACTION_FIELD, TYPE_FIELD, EXCLUDED_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer priority;
    private final String ruleId;
    private final WafAction action;
    private final WafOverrideAction overrideAction;
    private final String type;
    private final List<ExcludedRule> excludedRules;

    private ActivatedRule(BuilderImpl builder) {
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.action = builder.action;
        this.overrideAction = builder.overrideAction;
        this.type = builder.type;
        this.excludedRules = builder.excludedRules;
    }

    public Integer priority() {
        return this.priority;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public WafAction action() {
        return this.action;
    }

    public WafOverrideAction overrideAction() {
        return this.overrideAction;
    }

    public WafRuleType type() {
        return WafRuleType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public boolean hasExcludedRules() {
        return this.excludedRules != null && !(this.excludedRules instanceof SdkAutoConstructList);
    }

    public List<ExcludedRule> excludedRules() {
        return this.excludedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatedRule)) {
            return false;
        }
        ActivatedRule other = (ActivatedRule)obj;
        return Objects.equals(this.priority(), other.priority()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.overrideAction(), other.overrideAction()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.excludedRules(), other.excludedRules());
    }

    public String toString() {
        return ToString.builder((String)"ActivatedRule").add("Priority", (Object)this.priority()).add("RuleId", (Object)this.ruleId()).add("Action", (Object)this.action()).add("OverrideAction", (Object)this.overrideAction()).add("Type", (Object)this.typeAsString()).add("ExcludedRules", this.excludedRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "OverrideAction": {
                return Optional.ofNullable(clazz.cast(this.overrideAction()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ExcludedRules": {
                return Optional.ofNullable(clazz.cast(this.excludedRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivatedRule, T> g) {
        return obj -> g.apply((ActivatedRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer priority;
        private String ruleId;
        private WafAction action;
        private WafOverrideAction overrideAction;
        private String type;
        private List<ExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatedRule model) {
            this.priority(model.priority);
            this.ruleId(model.ruleId);
            this.action(model.action);
            this.overrideAction(model.overrideAction);
            this.type(model.type);
            this.excludedRules(model.excludedRules);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final WafAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(WafAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(WafAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final WafOverrideAction.Builder getOverrideAction() {
            return this.overrideAction != null ? this.overrideAction.toBuilder() : null;
        }

        @Override
        public final Builder overrideAction(WafOverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final void setOverrideAction(WafOverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WafRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<ExcludedRule.Builder> getExcludedRules() {
            return this.excludedRules != null ? (Collection)this.excludedRules.stream().map(ExcludedRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludedRules(Collection<ExcludedRule> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(ExcludedRule ... excludedRules) {
            this.excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<ExcludedRule.Builder> ... excludedRules) {
            this.excludedRules(Stream.of(excludedRules).map(c -> (ExcludedRule)((ExcludedRule.Builder)ExcludedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludedRules(Collection<ExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copyFromBuilder(excludedRules);
        }

        public ActivatedRule build() {
            return new ActivatedRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivatedRule> {
        public Builder priority(Integer var1);

        public Builder ruleId(String var1);

        public Builder action(WafAction var1);

        default public Builder action(Consumer<WafAction.Builder> action) {
            return this.action((WafAction)((WafAction.Builder)WafAction.builder().applyMutation(action)).build());
        }

        public Builder overrideAction(WafOverrideAction var1);

        default public Builder overrideAction(Consumer<WafOverrideAction.Builder> overrideAction) {
            return this.overrideAction((WafOverrideAction)((WafOverrideAction.Builder)WafOverrideAction.builder().applyMutation(overrideAction)).build());
        }

        public Builder type(String var1);

        public Builder type(WafRuleType var1);

        public Builder excludedRules(Collection<ExcludedRule> var1);

        public Builder excludedRules(ExcludedRule ... var1);

        public Builder excludedRules(Consumer<ExcludedRule.Builder> ... var1);
    }
}

