/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexPatternStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexPatternSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegexPatternSet> {
    private static final SdkField<String> REGEX_PATTERN_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegexPatternSetId").getter(RegexPatternSet.getter(RegexPatternSet::regexPatternSetId)).setter(RegexPatternSet.setter(Builder::regexPatternSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegexPatternSet.getter(RegexPatternSet::name)).setter(RegexPatternSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> REGEX_PATTERN_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegexPatternStrings").getter(RegexPatternSet.getter(RegexPatternSet::regexPatternStrings)).setter(RegexPatternSet.setter(Builder::regexPatternStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternStrings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_ID_FIELD, NAME_FIELD, REGEX_PATTERN_STRINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regexPatternSetId;
    private final String name;
    private final List<String> regexPatternStrings;

    private RegexPatternSet(BuilderImpl builder) {
        this.regexPatternSetId = builder.regexPatternSetId;
        this.name = builder.name;
        this.regexPatternStrings = builder.regexPatternStrings;
    }

    public String regexPatternSetId() {
        return this.regexPatternSetId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasRegexPatternStrings() {
        return this.regexPatternStrings != null && !(this.regexPatternStrings instanceof SdkAutoConstructList);
    }

    public List<String> regexPatternStrings() {
        return this.regexPatternStrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexPatternStrings() ? this.regexPatternStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSet)) {
            return false;
        }
        RegexPatternSet other = (RegexPatternSet)obj;
        return Objects.equals(this.regexPatternSetId(), other.regexPatternSetId()) && Objects.equals(this.name(), other.name()) && this.hasRegexPatternStrings() == other.hasRegexPatternStrings() && Objects.equals(this.regexPatternStrings(), other.regexPatternStrings());
    }

    public String toString() {
        return ToString.builder((String)"RegexPatternSet").add("RegexPatternSetId", (Object)this.regexPatternSetId()).add("Name", (Object)this.name()).add("RegexPatternStrings", this.hasRegexPatternStrings() ? this.regexPatternStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexPatternSetId": {
                return Optional.ofNullable(clazz.cast(this.regexPatternSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegexPatternStrings": {
                return Optional.ofNullable(clazz.cast(this.regexPatternStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSet, T> g) {
        return obj -> g.apply((RegexPatternSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regexPatternSetId;
        private String name;
        private List<String> regexPatternStrings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSet model) {
            this.regexPatternSetId(model.regexPatternSetId);
            this.name(model.name);
            this.regexPatternStrings(model.regexPatternStrings);
        }

        public final String getRegexPatternSetId() {
            return this.regexPatternSetId;
        }

        @Override
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getRegexPatternStrings() {
            if (this.regexPatternStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regexPatternStrings;
        }

        @Override
        public final Builder regexPatternStrings(Collection<String> regexPatternStrings) {
            this.regexPatternStrings = RegexPatternStringsCopier.copy(regexPatternStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternStrings(String ... regexPatternStrings) {
            this.regexPatternStrings(Arrays.asList(regexPatternStrings));
            return this;
        }

        public final void setRegexPatternStrings(Collection<String> regexPatternStrings) {
            this.regexPatternStrings = RegexPatternStringsCopier.copy(regexPatternStrings);
        }

        public RegexPatternSet build() {
            return new RegexPatternSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegexPatternSet> {
        public Builder regexPatternSetId(String var1);

        public Builder name(String var1);

        public Builder regexPatternStrings(Collection<String> var1);

        public Builder regexPatternStrings(String ... var1);
    }
}

