/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuplesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlInjectionMatchSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlInjectionMatchSet> {
    private static final SdkField<String> SQL_INJECTION_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlInjectionMatchSetId").getter(SqlInjectionMatchSet.getter(SqlInjectionMatchSet::sqlInjectionMatchSetId)).setter(SqlInjectionMatchSet.setter(Builder::sqlInjectionMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SqlInjectionMatchSet.getter(SqlInjectionMatchSet::name)).setter(SqlInjectionMatchSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SqlInjectionMatchTuple>> SQL_INJECTION_MATCH_TUPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SqlInjectionMatchTuples").getter(SqlInjectionMatchSet.getter(SqlInjectionMatchSet::sqlInjectionMatchTuples)).setter(SqlInjectionMatchSet.setter(Builder::sqlInjectionMatchTuples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchTuples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlInjectionMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_INJECTION_MATCH_SET_ID_FIELD, NAME_FIELD, SQL_INJECTION_MATCH_TUPLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sqlInjectionMatchSetId;
    private final String name;
    private final List<SqlInjectionMatchTuple> sqlInjectionMatchTuples;

    private SqlInjectionMatchSet(BuilderImpl builder) {
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.name = builder.name;
        this.sqlInjectionMatchTuples = builder.sqlInjectionMatchTuples;
    }

    public String sqlInjectionMatchSetId() {
        return this.sqlInjectionMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasSqlInjectionMatchTuples() {
        return this.sqlInjectionMatchTuples != null && !(this.sqlInjectionMatchTuples instanceof SdkAutoConstructList);
    }

    public List<SqlInjectionMatchTuple> sqlInjectionMatchTuples() {
        return this.sqlInjectionMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSqlInjectionMatchTuples() ? this.sqlInjectionMatchTuples() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSet)) {
            return false;
        }
        SqlInjectionMatchSet other = (SqlInjectionMatchSet)obj;
        return Objects.equals(this.sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId()) && Objects.equals(this.name(), other.name()) && this.hasSqlInjectionMatchTuples() == other.hasSqlInjectionMatchTuples() && Objects.equals(this.sqlInjectionMatchTuples(), other.sqlInjectionMatchTuples());
    }

    public String toString() {
        return ToString.builder((String)"SqlInjectionMatchSet").add("SqlInjectionMatchSetId", (Object)this.sqlInjectionMatchSetId()).add("Name", (Object)this.name()).add("SqlInjectionMatchTuples", this.hasSqlInjectionMatchTuples() ? this.sqlInjectionMatchTuples() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlInjectionMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SqlInjectionMatchTuples": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchTuples()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlInjectionMatchSet, T> g) {
        return obj -> g.apply((SqlInjectionMatchSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sqlInjectionMatchSetId;
        private String name;
        private List<SqlInjectionMatchTuple> sqlInjectionMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSet model) {
            this.sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            this.name(model.name);
            this.sqlInjectionMatchTuples(model.sqlInjectionMatchTuples);
        }

        public final String getSqlInjectionMatchSetId() {
            return this.sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SqlInjectionMatchTuple.Builder> getSqlInjectionMatchTuples() {
            if (this.sqlInjectionMatchTuples instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sqlInjectionMatchTuples != null ? (Collection)this.sqlInjectionMatchTuples.stream().map(SqlInjectionMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copy(sqlInjectionMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple ... sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples(Arrays.asList(sqlInjectionMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchTuples(Consumer<SqlInjectionMatchTuple.Builder> ... sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples(Stream.of(sqlInjectionMatchTuples).map(c -> (SqlInjectionMatchTuple)((SqlInjectionMatchTuple.Builder)SqlInjectionMatchTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple.BuilderImpl> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copyFromBuilder(sqlInjectionMatchTuples);
        }

        public SqlInjectionMatchSet build() {
            return new SqlInjectionMatchSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlInjectionMatchSet> {
        public Builder sqlInjectionMatchSetId(String var1);

        public Builder name(String var1);

        public Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> var1);

        public Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple ... var1);

        public Builder sqlInjectionMatchTuples(Consumer<SqlInjectionMatchTuple.Builder> ... var1);
    }
}

