/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListByteMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListByteMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListByteMatchSetsResponse.getter(ListByteMatchSetsResponse::nextMarker)).setter(ListByteMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<ByteMatchSetSummary>> BYTE_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ByteMatchSets").getter(ListByteMatchSetsResponse.getter(ListByteMatchSetsResponse::byteMatchSets)).setter(ListByteMatchSetsResponse.setter(Builder::byteMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ByteMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, BYTE_MATCH_SETS_FIELD));
    private final String nextMarker;
    private final List<ByteMatchSetSummary> byteMatchSets;

    private ListByteMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.byteMatchSets = builder.byteMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public boolean hasByteMatchSets() {
        return this.byteMatchSets != null && !(this.byteMatchSets instanceof SdkAutoConstructList);
    }

    public List<ByteMatchSetSummary> byteMatchSets() {
        return this.byteMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasByteMatchSets() ? this.byteMatchSets() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListByteMatchSetsResponse)) {
            return false;
        }
        ListByteMatchSetsResponse other = (ListByteMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasByteMatchSets() == other.hasByteMatchSets() && Objects.equals(this.byteMatchSets(), other.byteMatchSets());
    }

    public String toString() {
        return ToString.builder((String)"ListByteMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("ByteMatchSets", this.hasByteMatchSets() ? this.byteMatchSets() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "ByteMatchSets": {
                return Optional.ofNullable(clazz.cast(this.byteMatchSets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListByteMatchSetsResponse, T> g) {
        return obj -> g.apply((ListByteMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ByteMatchSetSummary> byteMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListByteMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.byteMatchSets(model.byteMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<ByteMatchSetSummary.Builder> getByteMatchSets() {
            if (this.byteMatchSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.byteMatchSets != null ? (Collection)this.byteMatchSets.stream().map(ByteMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copy(byteMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(ByteMatchSetSummary ... byteMatchSets) {
            this.byteMatchSets(Arrays.asList(byteMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(Consumer<ByteMatchSetSummary.Builder> ... byteMatchSets) {
            this.byteMatchSets(Stream.of(byteMatchSets).map(c -> (ByteMatchSetSummary)((ByteMatchSetSummary.Builder)ByteMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setByteMatchSets(Collection<ByteMatchSetSummary.BuilderImpl> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copyFromBuilder(byteMatchSets);
        }

        @Override
        public ListByteMatchSetsResponse build() {
            return new ListByteMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListByteMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder byteMatchSets(Collection<ByteMatchSetSummary> var1);

        public Builder byteMatchSets(ByteMatchSetSummary ... var1);

        public Builder byteMatchSets(Consumer<ByteMatchSetSummary.Builder> ... var1);
    }
}

