/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexPatternSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegexPatternSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(RegexPatternSetUpdate.getter(RegexPatternSetUpdate::actionAsString)).setter(RegexPatternSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> REGEX_PATTERN_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegexPatternString").getter(RegexPatternSetUpdate.getter(RegexPatternSetUpdate::regexPatternString)).setter(RegexPatternSetUpdate.setter(Builder::regexPatternString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, REGEX_PATTERN_STRING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String regexPatternString;

    private RegexPatternSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexPatternString = builder.regexPatternString;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public String regexPatternString() {
        return this.regexPatternString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSetUpdate)) {
            return false;
        }
        RegexPatternSetUpdate other = (RegexPatternSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.regexPatternString(), other.regexPatternString());
    }

    public String toString() {
        return ToString.builder((String)"RegexPatternSetUpdate").add("Action", (Object)this.actionAsString()).add("RegexPatternString", (Object)this.regexPatternString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "RegexPatternString": {
                return Optional.ofNullable(clazz.cast(this.regexPatternString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSetUpdate, T> g) {
        return obj -> g.apply((RegexPatternSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String regexPatternString;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSetUpdate model) {
            this.action(model.action);
            this.regexPatternString(model.regexPatternString);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRegexPatternString() {
            return this.regexPatternString;
        }

        @Override
        public final Builder regexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
            return this;
        }

        public final void setRegexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
        }

        public RegexPatternSetUpdate build() {
            return new RegexPatternSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegexPatternSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder regexPatternString(String var1);
    }
}

