/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.ListWebACLsRequest;
import software.amazon.awssdk.services.waf.transform.ListWebACLsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListWebACLsRequestMarshaller
implements Marshaller<Request<ListWebACLsRequest>, ListWebACLsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_20150824.ListWebACLs").serviceName("WAF").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public ListWebACLsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListWebACLsRequest> marshall(ListWebACLsRequest listWebACLsRequest) {
        Validate.paramNotNull((Object)((Object)listWebACLsRequest), (String)"listWebACLsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listWebACLsRequest);
            protocolMarshaller.startMarshalling();
            ListWebACLsRequestModelMarshaller.getInstance().marshall(listWebACLsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

