/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IPSetDescriptorMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final IPSetDescriptorMarshaller INSTANCE = new IPSetDescriptorMarshaller();

    private IPSetDescriptorMarshaller() {
    }

    public static IPSetDescriptorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IPSetDescriptor ipSetDescriptor, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ipSetDescriptor, (String)"ipSetDescriptor");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ipSetDescriptor.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)ipSetDescriptor.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

