/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WafRuleType {
    REGULAR("REGULAR"),
    RATE_BASED("RATE_BASED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WafRuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WafRuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WafRuleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WafRuleType> knownValues() {
        return Stream.of(WafRuleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

