/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourcesForWebACLRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, ListResourcesForWebACLRequest> {
    private final String webACLId;

    private ListResourcesForWebACLRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
    }

    public String webACLId() {
        return this.webACLId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForWebACLRequest)) {
            return false;
        }
        ListResourcesForWebACLRequest other = (ListResourcesForWebACLRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId());
    }

    public String toString() {
        return ToString.builder((String)"ListResourcesForWebACLRequest").add("WebACLId", (Object)this.webACLId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String webACLId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForWebACLRequest model) {
            this.webACLId(model.webACLId);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesForWebACLRequest build() {
            return new ListResourcesForWebACLRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, ListResourcesForWebACLRequest> {
        public Builder webACLId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

