/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRuleRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, GetRuleRequest> {
    private final String ruleId;

    private GetRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
    }

    public String ruleId() {
        return this.ruleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleRequest)) {
            return false;
        }
        GetRuleRequest other = (GetRuleRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId());
    }

    public String toString() {
        return ToString.builder((String)"GetRuleRequest").add("RuleId", (Object)this.ruleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleRequest model) {
            this.ruleId(model.ruleId);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetRuleRequest build() {
            return new GetRuleRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, GetRuleRequest> {
        public Builder ruleId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

