/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSizeConstraintSetRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
    private final String sizeConstraintSetId;
    private final String changeToken;
    private final List<SizeConstraintSetUpdate> updates;

    private UpdateSizeConstraintSetRequest(BuilderImpl builder) {
        super(builder);
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<SizeConstraintSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSizeConstraintSetRequest)) {
            return false;
        }
        UpdateSizeConstraintSetRequest other = (UpdateSizeConstraintSetRequest)((Object)obj);
        return Objects.equals(this.sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSizeConstraintSetRequest").add("SizeConstraintSetId", (Object)this.sizeConstraintSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeConstraintSetId": {
                return Optional.of(clazz.cast(this.sizeConstraintSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String changeToken;
        private List<SizeConstraintSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSizeConstraintSetRequest model) {
            this.sizeConstraintSetId(model.sizeConstraintSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<SizeConstraintSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(SizeConstraintSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<SizeConstraintSetUpdate> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SizeConstraintSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<SizeConstraintSetUpdate.BuilderImpl> updates) {
            this.updates = SizeConstraintSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateSizeConstraintSetRequest build() {
            return new UpdateSizeConstraintSetRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateSizeConstraintSetRequest> {
        public Builder sizeConstraintSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SizeConstraintSetUpdate> var1);

        public Builder updates(SizeConstraintSetUpdate ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

