/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.services.waf.model.PredicatesCopier;
import software.amazon.awssdk.services.waf.transform.RuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Rule
implements StructuredPojo,
ToCopyableBuilder<Builder, Rule> {
    private final String ruleId;
    private final String name;
    private final String metricName;
    private final List<Predicate> predicates;

    private Rule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.predicates = builder.predicates;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Predicate> predicates() {
        return this.predicates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.predicates(), other.predicates());
    }

    public String toString() {
        return ToString.builder((String)"Rule").add("RuleId", (Object)this.ruleId()).add("Name", (Object)this.name()).add("MetricName", (Object)this.metricName()).add("Predicates", this.predicates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Predicates": {
                return Optional.of(clazz.cast(this.predicates()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String name;
        private String metricName;
        private List<Predicate> predicates;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.ruleId(model.ruleId);
            this.name(model.name);
            this.metricName(model.metricName);
            this.predicates(model.predicates);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Predicate.Builder> getPredicates() {
            return this.predicates != null ? (Collection)this.predicates.stream().map(Predicate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder predicates(Collection<Predicate> predicates) {
            this.predicates = PredicatesCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(Predicate ... predicates) {
            this.predicates(Arrays.asList(predicates));
            return this;
        }

        public final void setPredicates(Collection<Predicate.BuilderImpl> predicates) {
            this.predicates = PredicatesCopier.copyFromBuilder(predicates);
        }

        public Rule build() {
            return new Rule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Rule> {
        public Builder ruleId(String var1);

        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder predicates(Collection<Predicate> var1);

        public Builder predicates(Predicate ... var1);
    }
}

