/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSqlInjectionMatchSetsResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
    private final String nextMarker;
    private final List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

    private ListSqlInjectionMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.sqlInjectionMatchSets = builder.sqlInjectionMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets() {
        return this.sqlInjectionMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSqlInjectionMatchSetsResponse)) {
            return false;
        }
        ListSqlInjectionMatchSetsResponse other = (ListSqlInjectionMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.sqlInjectionMatchSets(), other.sqlInjectionMatchSets());
    }

    public String toString() {
        return ToString.builder((String)"ListSqlInjectionMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("SqlInjectionMatchSets", this.sqlInjectionMatchSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "SqlInjectionMatchSets": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSqlInjectionMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.sqlInjectionMatchSets(model.sqlInjectionMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SqlInjectionMatchSetSummary.Builder> getSqlInjectionMatchSets() {
            return this.sqlInjectionMatchSets != null ? (Collection)this.sqlInjectionMatchSets.stream().map(SqlInjectionMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copy(sqlInjectionMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Arrays.asList(sqlInjectionMatchSets));
            return this;
        }

        public final void setSqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary.BuilderImpl> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copyFromBuilder(sqlInjectionMatchSets);
        }

        @Override
        public ListSqlInjectionMatchSetsResponse build() {
            return new ListSqlInjectionMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> var1);

        public Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... var1);
    }
}

